/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.events;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.fabric.FabricSoLoader;

@DoNotStrip
@SuppressLint(value={"MissingNativeLoadLibrary"})
public class EventEmitterWrapper {
    @DoNotStrip
    private final HybridData mHybridData;

    @DoNotStrip
    private EventEmitterWrapper(HybridData hybridData) {
        this.mHybridData = hybridData;
    }

    private native void dispatchEvent(@NonNull String var1, @NonNull NativeMap var2, int var3);

    private native void dispatchUniqueEvent(@NonNull String var1, @NonNull NativeMap var2);

    public synchronized void dispatch(@NonNull String eventName, @Nullable WritableMap params, int eventCategory) {
        if (!this.isValid()) {
            return;
        }
        this.dispatchEvent(eventName, (NativeMap)((Object)params), eventCategory);
    }

    public synchronized void dispatchUnique(@NonNull String eventName, @Nullable WritableMap params) {
        if (!this.isValid()) {
            return;
        }
        this.dispatchUniqueEvent(eventName, (NativeMap)((Object)params));
    }

    public synchronized void destroy() {
        if (this.mHybridData != null) {
            this.mHybridData.resetNative();
        }
    }

    private boolean isValid() {
        if (this.mHybridData != null) {
            return this.mHybridData.isValid();
        }
        return false;
    }

    static {
        FabricSoLoader.staticInit();
    }
}

