/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.WritableMap;

@DoNotStrip
public class WritableNativeMap
extends ReadableNativeMap
implements WritableMap {
    @Override
    public native void putBoolean(@NonNull String var1, boolean var2);

    @Override
    public native void putDouble(@NonNull String var1, double var2);

    @Override
    public native void putInt(@NonNull String var1, int var2);

    @Override
    public native void putNull(@NonNull String var1);

    @Override
    public native void putString(@NonNull String var1, @Nullable String var2);

    @Override
    public void putMap(@NonNull String key, @Nullable ReadableMap value) {
        Assertions.assertCondition((value == null || value instanceof ReadableNativeMap ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeMap(key, (ReadableNativeMap)value);
    }

    @Override
    public void putArray(@NonNull String key, @Nullable ReadableArray value) {
        Assertions.assertCondition((value == null || value instanceof ReadableNativeArray ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeArray(key, (ReadableNativeArray)value);
    }

    @Override
    public void merge(@NonNull ReadableMap source) {
        Assertions.assertCondition((boolean)(source instanceof ReadableNativeMap), (String)"Illegal type provided");
        this.mergeNativeMap((ReadableNativeMap)source);
    }

    @Override
    public WritableMap copy() {
        WritableNativeMap target = new WritableNativeMap();
        target.merge(this);
        return target;
    }

    public WritableNativeMap() {
        super(WritableNativeMap.initHybrid());
    }

    private static native HybridData initHybrid();

    private native void putNativeMap(String var1, ReadableNativeMap var2);

    private native void putNativeArray(String var1, ReadableNativeArray var2);

    private native void mergeNativeMap(ReadableNativeMap var1);

    static {
        ReactBridge.staticInit();
    }
}

