/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.util.JsonWriter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonWriterHelper {
    public static void value(JsonWriter writer, Object value) throws IOException {
        if (value instanceof Map) {
            JsonWriterHelper.mapValue(writer, (Map)value);
        } else if (value instanceof List) {
            JsonWriterHelper.listValue(writer, (List)value);
        } else if (value instanceof ReadableMap) {
            JsonWriterHelper.readableMapValue(writer, (ReadableMap)value);
        } else if (value instanceof ReadableArray) {
            JsonWriterHelper.readableArrayValue(writer, (ReadableArray)value);
        } else if (value instanceof Dynamic) {
            JsonWriterHelper.dynamicValue(writer, (Dynamic)value);
        } else {
            JsonWriterHelper.objectValue(writer, value);
        }
    }

    private static void dynamicValue(JsonWriter writer, Dynamic value) throws IOException {
        switch (value.getType()) {
            case Null: {
                writer.nullValue();
                break;
            }
            case Boolean: {
                writer.value(value.asBoolean());
                break;
            }
            case Number: {
                writer.value(value.asDouble());
                break;
            }
            case String: {
                writer.value(value.asString());
                break;
            }
            case Map: {
                JsonWriterHelper.readableMapValue(writer, value.asMap());
                break;
            }
            case Array: {
                JsonWriterHelper.readableArrayValue(writer, value.asArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)value.getType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readableMapValue(JsonWriter writer, ReadableMap value) throws IOException {
        writer.beginObject();
        try {
            ReadableMapKeySetIterator iterator2 = value.keySetIterator();
            block11: while (iterator2.hasNextKey()) {
                String key = iterator2.nextKey();
                writer.name(key);
                switch (value.getType(key)) {
                    case Null: {
                        writer.nullValue();
                        continue block11;
                    }
                    case Boolean: {
                        writer.value(value.getBoolean(key));
                        continue block11;
                    }
                    case Number: {
                        writer.value(value.getDouble(key));
                        continue block11;
                    }
                    case String: {
                        writer.value(value.getString(key));
                        continue block11;
                    }
                    case Map: {
                        JsonWriterHelper.readableMapValue(writer, value.getMap(key));
                        continue block11;
                    }
                    case Array: {
                        JsonWriterHelper.readableArrayValue(writer, value.getArray(key));
                        continue block11;
                    }
                }
                throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)value.getType(key)));
            }
        }
        finally {
            writer.endObject();
        }
    }

    public static void readableArrayValue(JsonWriter writer, ReadableArray value) throws IOException {
        writer.beginArray();
        try {
            block11: for (int key = 0; key < value.size(); ++key) {
                switch (value.getType(key)) {
                    case Null: {
                        writer.nullValue();
                        continue block11;
                    }
                    case Boolean: {
                        writer.value(value.getBoolean(key));
                        continue block11;
                    }
                    case Number: {
                        writer.value(value.getDouble(key));
                        continue block11;
                    }
                    case String: {
                        writer.value(value.getString(key));
                        continue block11;
                    }
                    case Map: {
                        JsonWriterHelper.readableMapValue(writer, value.getMap(key));
                        continue block11;
                    }
                    case Array: {
                        JsonWriterHelper.readableArrayValue(writer, value.getArray(key));
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type: " + (Object)((Object)value.getType(key)));
                    }
                }
            }
        }
        finally {
            writer.endArray();
        }
    }

    private static void mapValue(JsonWriter writer, Map<?, ?> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            writer.name(entry.getKey().toString());
            JsonWriterHelper.value(writer, entry.getValue());
        }
        writer.endObject();
    }

    private static void listValue(JsonWriter writer, List<?> list) throws IOException {
        writer.beginArray();
        for (Object item : list) {
            JsonWriterHelper.objectValue(writer, item);
        }
        writer.endArray();
    }

    private static void objectValue(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof String) {
            writer.value((String)value);
        } else if (value instanceof Number) {
            writer.value((Number)value);
        } else if (value instanceof Boolean) {
            writer.value(((Boolean)value).booleanValue());
        } else {
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }
}

