/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;

class TrackingAnimatedNode
extends AnimatedNode {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final int mAnimationId;
    private final int mToValueNode;
    private final int mValueNode;
    private final JavaOnlyMap mAnimationConfig;

    TrackingAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.mAnimationId = config.getInt("animationId");
        this.mToValueNode = config.getInt("toValue");
        this.mValueNode = config.getInt("value");
        this.mAnimationConfig = JavaOnlyMap.deepClone(config.getMap("animationConfig"));
    }

    @Override
    public void update() {
        AnimatedNode toValue = this.mNativeAnimatedNodesManager.getNodeById(this.mToValueNode);
        this.mAnimationConfig.putDouble("toValue", ((ValueAnimatedNode)toValue).getValue());
        this.mNativeAnimatedNodesManager.startAnimatingNode(this.mAnimationId, this.mValueNode, this.mAnimationConfig, null);
    }

    @Override
    public String prettyPrint() {
        return "TrackingAnimatedNode[" + this.mTag + "]: animationID: " + this.mAnimationId + " toValueNode: " + this.mToValueNode + " valueNode: " + this.mValueNode + " animationConfig: " + this.mAnimationConfig;
    }
}

