/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;

class MultiplicationAnimatedNode
extends ValueAnimatedNode {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final int[] mInputNodes;

    public MultiplicationAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
        ReadableArray inputNodes = config.getArray("input");
        this.mInputNodes = new int[inputNodes.size()];
        for (int i = 0; i < this.mInputNodes.length; ++i) {
            this.mInputNodes[i] = inputNodes.getInt(i);
        }
    }

    @Override
    public void update() {
        this.mValue = 1.0;
        for (int i = 0; i < this.mInputNodes.length; ++i) {
            AnimatedNode animatedNode = this.mNativeAnimatedNodesManager.getNodeById(this.mInputNodes[i]);
            if (animatedNode != null && animatedNode instanceof ValueAnimatedNode) {
                this.mValue *= ((ValueAnimatedNode)animatedNode).getValue();
                continue;
            }
            throw new JSApplicationCausedNativeException("Illegal node ID set as an input for Animated.multiply node");
        }
    }

    @Override
    public String prettyPrint() {
        return "MultiplicationAnimatedNode[" + this.mTag + "]: input nodes: " + (this.mInputNodes != null ? this.mInputNodes.toString() : "null") + " - super: " + super.prettyPrint();
    }
}

