/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactActivity;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactDelegate;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactRootView;
import com.facebook.react.bridge.Callback;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.modules.core.PermissionListener;

public class ReactActivityDelegate {
    @Nullable
    private final Activity mActivity;
    @Nullable
    private final String mMainComponentName;
    @Nullable
    private PermissionListener mPermissionListener;
    @Nullable
    private Callback mPermissionsCallback;
    private ReactDelegate mReactDelegate;

    @Deprecated
    public ReactActivityDelegate(@Nullable Activity activity, @Nullable String mainComponentName) {
        this.mActivity = activity;
        this.mMainComponentName = mainComponentName;
    }

    public ReactActivityDelegate(@Nullable ReactActivity activity, @Nullable String mainComponentName) {
        this.mActivity = activity;
        this.mMainComponentName = mainComponentName;
    }

    @Nullable
    protected Bundle getLaunchOptions() {
        return null;
    }

    @Nullable
    protected Bundle composeLaunchOptions() {
        Bundle composedLaunchOptions = this.getLaunchOptions();
        if (this.isFabricEnabled() && composedLaunchOptions == null) {
            composedLaunchOptions = new Bundle();
        }
        return composedLaunchOptions;
    }

    protected ReactRootView createRootView() {
        return new ReactRootView(this.getContext());
    }

    protected ReactRootView createRootView(Bundle initialProps) {
        return new ReactRootView(this.getContext());
    }

    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getPlainActivity().getApplication()).getReactNativeHost();
    }

    public ReactHost getReactHost() {
        return ((ReactApplication)this.getPlainActivity().getApplication()).getReactHost();
    }

    @Nullable
    protected ReactDelegate getReactDelegate() {
        return this.mReactDelegate;
    }

    public ReactInstanceManager getReactInstanceManager() {
        return this.mReactDelegate.getReactInstanceManager();
    }

    public String getMainComponentName() {
        return this.mMainComponentName;
    }

    protected void onCreate(Bundle savedInstanceState) {
        String mainComponentName = this.getMainComponentName();
        final Bundle launchOptions = this.composeLaunchOptions();
        this.mReactDelegate = ReactFeatureFlags.enableBridgelessArchitecture ? new ReactDelegate(this.getPlainActivity(), this.getReactHost(), mainComponentName, launchOptions) : new ReactDelegate(this.getPlainActivity(), this.getReactNativeHost(), mainComponentName, launchOptions, this.isFabricEnabled()){

            @Override
            protected ReactRootView createRootView() {
                return ReactActivityDelegate.this.createRootView(launchOptions);
            }
        };
        if (mainComponentName != null) {
            this.loadApp(mainComponentName);
        }
    }

    protected void loadApp(String appKey) {
        this.mReactDelegate.loadApp(appKey);
        this.getPlainActivity().setContentView((View)this.mReactDelegate.getReactRootView());
    }

    protected void onPause() {
        this.mReactDelegate.onHostPause();
    }

    protected void onResume() {
        this.mReactDelegate.onHostResume();
        if (this.mPermissionsCallback != null) {
            this.mPermissionsCallback.invoke(new Object[0]);
            this.mPermissionsCallback = null;
        }
    }

    protected void onDestroy() {
        this.mReactDelegate.onHostDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mReactDelegate.onActivityResult(requestCode, resultCode, data, true);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mReactDelegate.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mReactDelegate.shouldShowDevMenuOrReload(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return this.mReactDelegate.onKeyLongPress(keyCode);
    }

    public boolean onBackPressed() {
        return this.mReactDelegate.onBackPressed();
    }

    public boolean onNewIntent(Intent intent) {
        return this.mReactDelegate.onNewIntent(intent);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.mReactDelegate.onWindowFocusChanged(hasFocus);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mReactDelegate.onConfigurationChanged(newConfig);
    }

    public void requestPermissions(String[] permissions, int requestCode, PermissionListener listener) {
        this.mPermissionListener = listener;
        this.getPlainActivity().requestPermissions(permissions, requestCode);
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        this.mPermissionsCallback = new Callback(){

            @Override
            public void invoke(Object ... args) {
                if (ReactActivityDelegate.this.mPermissionListener != null && ReactActivityDelegate.this.mPermissionListener.onRequestPermissionsResult(requestCode, permissions, grantResults)) {
                    ReactActivityDelegate.this.mPermissionListener = null;
                }
            }
        };
    }

    protected Context getContext() {
        return (Context)Assertions.assertNotNull((Object)this.mActivity);
    }

    protected Activity getPlainActivity() {
        return (Activity)this.getContext();
    }

    protected boolean isFabricEnabled() {
        return ReactFeatureFlags.enableFabricRenderer;
    }
}

