/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.react.views.view.ReactViewBackgroundDrawable;

public class ReactViewBackgroundManager {
    @Nullable
    private ReactViewBackgroundDrawable mReactBackgroundDrawable;
    private View mView;
    private int mColor = 0;

    public ReactViewBackgroundManager(View view) {
        this.mView = view;
    }

    public void cleanup() {
        ViewCompat.setBackground((View)this.mView, null);
        this.mView = null;
        this.mReactBackgroundDrawable = null;
    }

    private ReactViewBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mReactBackgroundDrawable == null) {
            this.mReactBackgroundDrawable = new ReactViewBackgroundDrawable(this.mView.getContext());
            Drawable backgroundDrawable = this.mView.getBackground();
            ViewCompat.setBackground((View)this.mView, null);
            if (backgroundDrawable == null) {
                ViewCompat.setBackground((View)this.mView, (Drawable)this.mReactBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mReactBackgroundDrawable, backgroundDrawable});
                ViewCompat.setBackground((View)this.mView, (Drawable)layerDrawable);
            }
        }
        return this.mReactBackgroundDrawable;
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mReactBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    public int getBackgroundColor() {
        return this.mColor;
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.getOrCreateReactViewBackground().setBorderColor(position, color, alpha);
    }

    public int getBorderColor(int position) {
        return this.getOrCreateReactViewBackground().getBorderColor(position);
    }

    public void setBorderRadius(float borderRadius) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.getOrCreateReactViewBackground().setBorderStyle(style2);
    }
}

