/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.internal.span;

import android.graphics.Paint;
import android.text.style.LineHeightSpan;
import com.facebook.react.views.text.internal.span.ReactSpan;

public class CustomLineHeightSpan
implements LineHeightSpan,
ReactSpan {
    private final int mHeight;

    public CustomLineHeightSpan(float height) {
        this.mHeight = (int)Math.ceil(height);
    }

    public int getLineHeight() {
        return this.mHeight;
    }

    public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
        if (fm.descent > this.mHeight) {
            fm.bottom = fm.descent = Math.min(this.mHeight, fm.descent);
            fm.ascent = 0;
            fm.top = 0;
        } else if (-fm.ascent + fm.descent > this.mHeight) {
            fm.bottom = fm.descent;
            fm.top = fm.ascent = -this.mHeight + fm.descent;
        } else if (-fm.ascent + fm.bottom > this.mHeight) {
            fm.top = fm.ascent;
            fm.bottom = fm.ascent + this.mHeight;
        } else if (-fm.top + fm.bottom > this.mHeight) {
            fm.top = fm.bottom - this.mHeight;
        } else {
            int additional = this.mHeight - (-fm.top + fm.bottom);
            int top = (int)((double)fm.top - Math.ceil((float)additional / 2.0f));
            int bottom = (int)((double)fm.bottom + Math.floor((float)additional / 2.0f));
            fm.top = top;
            fm.ascent = top;
            fm.descent = bottom;
            fm.bottom = bottom;
        }
    }
}

