/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.assets.ReactFontManager;
import java.util.ArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactTypefaceUtils {
    public static int parseFontWeight(@Nullable String fontWeightString) {
        if (fontWeightString != null) {
            switch (fontWeightString) {
                case "100": {
                    return 100;
                }
                case "200": {
                    return 200;
                }
                case "300": {
                    return 300;
                }
                case "normal": 
                case "400": {
                    return 400;
                }
                case "500": {
                    return 500;
                }
                case "600": {
                    return 600;
                }
                case "bold": 
                case "700": {
                    return 700;
                }
                case "800": {
                    return 800;
                }
                case "900": {
                    return 900;
                }
            }
        }
        return -1;
    }

    public static int parseFontStyle(@Nullable String fontStyleString) {
        if (fontStyleString != null) {
            if ("italic".equals(fontStyleString)) {
                return 2;
            }
            if ("normal".equals(fontStyleString)) {
                return 0;
            }
        }
        return -1;
    }

    @Nullable
    public static String parseFontVariant(@Nullable ReadableArray fontVariantArray) {
        if (fontVariantArray == null || fontVariantArray.size() == 0) {
            return null;
        }
        ArrayList<String> features = new ArrayList<String>();
        block70: for (int i = 0; i < fontVariantArray.size(); ++i) {
            String fontVariant = fontVariantArray.getString(i);
            if (fontVariant == null) continue;
            switch (fontVariant) {
                case "small-caps": {
                    features.add("'smcp'");
                    continue block70;
                }
                case "oldstyle-nums": {
                    features.add("'onum'");
                    continue block70;
                }
                case "lining-nums": {
                    features.add("'lnum'");
                    continue block70;
                }
                case "tabular-nums": {
                    features.add("'tnum'");
                    continue block70;
                }
                case "proportional-nums": {
                    features.add("'pnum'");
                    continue block70;
                }
                case "common-ligatures": {
                    features.add("'liga'");
                    features.add("'clig'");
                    continue block70;
                }
                case "no-common-ligatures": {
                    features.add("'liga' off");
                    features.add("'clig' off");
                    continue block70;
                }
                case "discretionary-ligatures": {
                    features.add("'dlig'");
                    continue block70;
                }
                case "no-discretionary-ligatures": {
                    features.add("'dlig' off");
                    continue block70;
                }
                case "historical-ligatures": {
                    features.add("'hlig'");
                    continue block70;
                }
                case "no-historical-ligatures": {
                    features.add("'hlig' off");
                    continue block70;
                }
                case "contextual": {
                    features.add("'calt'");
                    continue block70;
                }
                case "no-contextual": {
                    features.add("'calt' off");
                    continue block70;
                }
                case "stylistic-one": {
                    features.add("'ss01'");
                    continue block70;
                }
                case "stylistic-two": {
                    features.add("'ss02'");
                    continue block70;
                }
                case "stylistic-three": {
                    features.add("'ss03'");
                    continue block70;
                }
                case "stylistic-four": {
                    features.add("'ss04'");
                    continue block70;
                }
                case "stylistic-five": {
                    features.add("'ss05'");
                    continue block70;
                }
                case "stylistic-six": {
                    features.add("'ss06'");
                    continue block70;
                }
                case "stylistic-seven": {
                    features.add("'ss07'");
                    continue block70;
                }
                case "stylistic-eight": {
                    features.add("'ss08'");
                    continue block70;
                }
                case "stylistic-nine": {
                    features.add("'ss09'");
                    continue block70;
                }
                case "stylistic-ten": {
                    features.add("'ss10'");
                    continue block70;
                }
                case "stylistic-eleven": {
                    features.add("'ss11'");
                    continue block70;
                }
                case "stylistic-twelve": {
                    features.add("'ss12'");
                    continue block70;
                }
                case "stylistic-thirteen": {
                    features.add("'ss13'");
                    continue block70;
                }
                case "stylistic-fourteen": {
                    features.add("'ss14'");
                    continue block70;
                }
                case "stylistic-fifteen": {
                    features.add("'ss15'");
                    continue block70;
                }
                case "stylistic-sixteen": {
                    features.add("'ss16'");
                    continue block70;
                }
                case "stylistic-seventeen": {
                    features.add("'ss17'");
                    continue block70;
                }
                case "stylistic-eighteen": {
                    features.add("'ss18'");
                    continue block70;
                }
                case "stylistic-nineteen": {
                    features.add("'ss19'");
                    continue block70;
                }
                case "stylistic-twenty": {
                    features.add("'ss20'");
                }
            }
        }
        return TextUtils.join((CharSequence)", ", features);
    }

    public static Typeface applyStyles(@Nullable Typeface typeface, int style2, int weight, @Nullable String fontFamilyName, AssetManager assetManager) {
        ReactFontManager.TypefaceStyle typefaceStyle = new ReactFontManager.TypefaceStyle(style2, weight);
        if (fontFamilyName == null) {
            return typefaceStyle.apply(typeface == null ? Typeface.DEFAULT : typeface);
        }
        return ReactFontManager.getInstance().getTypeface(fontFamilyName, typefaceStyle, assetManager);
    }
}

