/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.views.scroll.ScrollEventType;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ScrollEvent
extends Event<ScrollEvent> {
    private static String TAG = ScrollEvent.class.getSimpleName();
    private static final Pools.SynchronizedPool<ScrollEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    private float mScrollX;
    private float mScrollY;
    private float mXVelocity;
    private float mYVelocity;
    private int mContentWidth;
    private int mContentHeight;
    private int mScrollViewWidth;
    private int mScrollViewHeight;
    @Nullable
    private ScrollEventType mScrollEventType;

    @Deprecated
    public static ScrollEvent obtain(int viewTag, ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        return ScrollEvent.obtain(-1, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
    }

    public static ScrollEvent obtain(int surfaceId, int viewTag, ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        ScrollEvent event = (ScrollEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new ScrollEvent();
        }
        event.init(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
        return event;
    }

    @Override
    public void onDispose() {
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, e);
        }
    }

    private ScrollEvent() {
    }

    private void init(int surfaceId, int viewTag, ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        super.init(surfaceId, viewTag);
        this.mScrollEventType = scrollEventType;
        this.mScrollX = scrollX;
        this.mScrollY = scrollY;
        this.mXVelocity = xVelocity;
        this.mYVelocity = yVelocity;
        this.mContentWidth = contentWidth;
        this.mContentHeight = contentHeight;
        this.mScrollViewWidth = scrollViewWidth;
        this.mScrollViewHeight = scrollViewHeight;
    }

    @Override
    public String getEventName() {
        return ScrollEventType.getJSEventName((ScrollEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mScrollEventType))));
    }

    @Override
    public boolean canCoalesce() {
        return this.mScrollEventType == ScrollEventType.SCROLL;
    }

    @Override
    @Nullable
    protected WritableMap getEventData() {
        WritableMap contentInset = Arguments.createMap();
        contentInset.putDouble("top", 0.0);
        contentInset.putDouble("bottom", 0.0);
        contentInset.putDouble("left", 0.0);
        contentInset.putDouble("right", 0.0);
        WritableMap contentOffset = Arguments.createMap();
        contentOffset.putDouble("x", PixelUtil.toDIPFromPixel(this.mScrollX));
        contentOffset.putDouble("y", PixelUtil.toDIPFromPixel(this.mScrollY));
        WritableMap contentSize = Arguments.createMap();
        contentSize.putDouble("width", PixelUtil.toDIPFromPixel(this.mContentWidth));
        contentSize.putDouble("height", PixelUtil.toDIPFromPixel(this.mContentHeight));
        WritableMap layoutMeasurement = Arguments.createMap();
        layoutMeasurement.putDouble("width", PixelUtil.toDIPFromPixel(this.mScrollViewWidth));
        layoutMeasurement.putDouble("height", PixelUtil.toDIPFromPixel(this.mScrollViewHeight));
        WritableMap velocity = Arguments.createMap();
        velocity.putDouble("x", this.mXVelocity);
        velocity.putDouble("y", this.mYVelocity);
        WritableMap event = Arguments.createMap();
        event.putMap("contentInset", contentInset);
        event.putMap("contentOffset", contentOffset);
        event.putMap("contentSize", contentSize);
        event.putMap("layoutMeasurement", layoutMeasurement);
        event.putMap("velocity", velocity);
        event.putInt("target", this.getViewTag());
        event.putBoolean("responderIgnoreScroll", true);
        return event;
    }
}

