/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.systeminfo;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Locale;

public class AndroidInfoHelpers {
    public static final String EMULATOR_LOCALHOST = "10.0.2.2";
    public static final String GENYMOTION_LOCALHOST = "10.0.3.2";
    public static final String DEVICE_LOCALHOST = "localhost";
    public static final String METRO_HOST_PROP_NAME = "metro.host";
    private static final String TAG = AndroidInfoHelpers.class.getSimpleName();
    private static String metroHostPropValue = null;

    private static boolean isRunningOnGenymotion() {
        return Build.FINGERPRINT.contains("vbox");
    }

    private static boolean isRunningOnStockEmulator() {
        return Build.FINGERPRINT.contains("generic") || Build.FINGERPRINT.startsWith("google/sdk_gphone");
    }

    public static String getServerHost(Integer port) {
        return AndroidInfoHelpers.getServerIpAddress(port);
    }

    public static String getServerHost(Context context) {
        return AndroidInfoHelpers.getServerIpAddress(AndroidInfoHelpers.getDevServerPort(context));
    }

    public static String getAdbReverseTcpCommand(Integer port) {
        return "adb reverse tcp:" + port + " tcp:" + port;
    }

    public static String getAdbReverseTcpCommand(Context context) {
        return AndroidInfoHelpers.getAdbReverseTcpCommand(AndroidInfoHelpers.getDevServerPort(context));
    }

    public static String getFriendlyDeviceName() {
        if (AndroidInfoHelpers.isRunningOnGenymotion()) {
            return Build.MODEL;
        }
        return Build.MODEL + " - " + Build.VERSION.RELEASE + " - API " + Build.VERSION.SDK_INT;
    }

    private static Integer getDevServerPort(Context context) {
        Resources resources = context.getResources();
        return resources.getInteger(R.integer.react_native_dev_server_port);
    }

    private static String getServerIpAddress(int port) {
        String metroHostProp = AndroidInfoHelpers.getMetroHostPropValue();
        String ipAddress = !metroHostProp.equals("") ? metroHostProp : (AndroidInfoHelpers.isRunningOnGenymotion() ? GENYMOTION_LOCALHOST : (AndroidInfoHelpers.isRunningOnStockEmulator() ? EMULATOR_LOCALHOST : DEVICE_LOCALHOST));
        return String.format(Locale.US, "%s:%d", ipAddress, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getMetroHostPropValue() {
        if (metroHostPropValue != null) {
            return metroHostPropValue;
        }
        Process process = null;
        BufferedReader reader = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(new String[]{"/system/bin/getprop", METRO_HOST_PROP_NAME});
            reader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
            String lastLine = "";
            while ((line = reader.readLine()) != null) {
                lastLine = line;
            }
            metroHostPropValue = lastLine;
        }
        catch (Exception e) {
            FLog.w((String)TAG, (String)"Failed to query for metro.host prop:", (Throwable)e);
            metroHostPropValue = "";
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            if (process != null) {
                process.destroy();
            }
        }
        return metroHostPropValue;
    }
}

