/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.text.TextUtils;
import android.webkit.CookieManager;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactContext;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ForwardingCookieHandler
extends CookieHandler {
    private static final String VERSION_ZERO_HEADER = "Set-cookie";
    private static final String VERSION_ONE_HEADER = "Set-cookie2";
    private static final String COOKIE_HEADER = "Cookie";
    private final ReactContext mContext;
    @Nullable
    private CookieManager mCookieManager;

    public ForwardingCookieHandler(ReactContext context) {
        this.mContext = context;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> headers) throws IOException {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager == null) {
            return Collections.emptyMap();
        }
        String cookies = cookieManager.getCookie(uri.toString());
        if (TextUtils.isEmpty((CharSequence)cookies)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(COOKIE_HEADER, Collections.singletonList(cookies));
    }

    @Override
    public void put(URI uri, Map<String, List<String>> headers) throws IOException {
        String url = uri.toString();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key == null || !ForwardingCookieHandler.isCookieHeader(key)) continue;
            this.addCookies(url, entry.getValue());
        }
    }

    public void clearCookies(Callback callback) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager != null) {
            cookieManager.removeAllCookies(value -> callback.invoke(value));
        }
    }

    public void destroy() {
    }

    public void addCookies(String url, List<String> cookies) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager == null) {
            return;
        }
        for (String cookie : cookies) {
            this.addCookieAsync(url, cookie);
        }
        cookieManager.flush();
    }

    private void addCookieAsync(String url, String cookie) {
        CookieManager cookieManager = this.getCookieManager();
        if (cookieManager != null) {
            cookieManager.setCookie(url, cookie, null);
        }
    }

    private static boolean isCookieHeader(String name) {
        return name.equalsIgnoreCase(VERSION_ZERO_HEADER) || name.equalsIgnoreCase(VERSION_ONE_HEADER);
    }

    @Nullable
    private CookieManager getCookieManager() {
        if (this.mCookieManager == null) {
            try {
                this.mCookieManager = CookieManager.getInstance();
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.mCookieManager;
    }
}

