/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.appearance;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import com.facebook.fbreact.specs.NativeAppearanceSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="Appearance")
public class AppearanceModule
extends NativeAppearanceSpec {
    private static final String APPEARANCE_CHANGED_EVENT_NAME = "appearanceChanged";
    private String mColorScheme = "light";
    @Nullable
    private final OverrideColorScheme mOverrideColorScheme;

    public AppearanceModule(ReactApplicationContext reactContext) {
        this(reactContext, null);
    }

    public AppearanceModule(ReactApplicationContext reactContext, @Nullable OverrideColorScheme overrideColorScheme) {
        super(reactContext);
        this.mOverrideColorScheme = overrideColorScheme;
        this.mColorScheme = this.colorSchemeForCurrentConfiguration((Context)reactContext);
    }

    private String colorSchemeForCurrentConfiguration(Context context) {
        if (this.mOverrideColorScheme != null) {
            return this.mOverrideColorScheme.getScheme();
        }
        int currentNightMode = context.getResources().getConfiguration().uiMode & 0x30;
        switch (currentNightMode) {
            case 16: {
                return "light";
            }
            case 32: {
                return "dark";
            }
        }
        return "light";
    }

    @Override
    public void setColorScheme(String style2) {
        if (style2.equals("dark")) {
            AppCompatDelegate.setDefaultNightMode((int)2);
        } else if (style2.equals("light")) {
            AppCompatDelegate.setDefaultNightMode((int)1);
        } else if (style2.equals("unspecified")) {
            AppCompatDelegate.setDefaultNightMode((int)-1);
        }
    }

    @Override
    public String getColorScheme() {
        Activity activity = this.getCurrentActivity();
        this.mColorScheme = this.colorSchemeForCurrentConfiguration((Context)(activity != null ? activity : this.getReactApplicationContext()));
        return this.mColorScheme;
    }

    @Override
    public void addListener(String eventName) {
    }

    @Override
    public void removeListeners(double count) {
    }

    public void onConfigurationChanged(Context currentContext) {
        String newColorScheme = this.colorSchemeForCurrentConfiguration(currentContext);
        if (!this.mColorScheme.equals(newColorScheme)) {
            this.mColorScheme = newColorScheme;
            this.emitAppearanceChanged(this.mColorScheme);
        }
    }

    public void emitAppearanceChanged(String colorScheme) {
        WritableMap appearancePreferences = Arguments.createMap();
        appearancePreferences.putString("colorScheme", colorScheme);
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
        if (reactApplicationContext != null) {
            reactApplicationContext.emitDeviceEvent(APPEARANCE_CHANGED_EVENT_NAME, appearancePreferences);
        }
    }

    public static interface OverrideColorScheme {
        public String getScheme();
    }
}

