/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.jstasks;

import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.jstasks.HeadlessJsTaskRetryPolicy;
import com.facebook.react.jstasks.NoRetryPolicy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LinearCountingRetryPolicy
implements HeadlessJsTaskRetryPolicy {
    private final int mRetryAttempts;
    private final int mDelayBetweenAttemptsInMs;

    public LinearCountingRetryPolicy(int retryAttempts, int delayBetweenAttemptsInMs) {
        this.mRetryAttempts = retryAttempts;
        this.mDelayBetweenAttemptsInMs = delayBetweenAttemptsInMs;
    }

    @Override
    public boolean canRetry() {
        return this.mRetryAttempts > 0;
    }

    @Override
    public int getDelay() {
        return this.mDelayBetweenAttemptsInMs;
    }

    @Override
    public HeadlessJsTaskRetryPolicy update() {
        int remainingRetryAttempts = this.mRetryAttempts - 1;
        if (remainingRetryAttempts > 0) {
            return new LinearCountingRetryPolicy(remainingRetryAttempts, this.mDelayBetweenAttemptsInMs);
        }
        return NoRetryPolicy.INSTANCE;
    }

    @Override
    public HeadlessJsTaskRetryPolicy copy() {
        return new LinearCountingRetryPolicy(this.mRetryAttempts, this.mDelayBetweenAttemptsInMs);
    }
}

