/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.internal.turbomodule.core;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class TurboModuleInteropUtils {
    TurboModuleInteropUtils() {
    }

    static List<MethodDescriptor> getMethodDescriptorsFromModule(NativeModule module) {
        Method[] methods = TurboModuleInteropUtils.getMethodsFromModule(module);
        ArrayList<MethodDescriptor> methodDescriptors = new ArrayList<MethodDescriptor>();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            ReactMethod annotation = method.getAnnotation(ReactMethod.class);
            String moduleName = module.getName();
            String methodName = method.getName();
            if (annotation == null && !"getConstants".equals(methodName)) continue;
            if (methodNames.contains(methodName)) {
                throw new ParsingException(moduleName, "Module exports two methods to JavaScript with the same name: \"" + methodName);
            }
            methodNames.add(methodName);
            Class<?>[] paramClasses = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if ("getConstants".equals(methodName) ? returnType != Map.class : annotation.isBlockingSynchronousMethod() && returnType == Void.TYPE || annotation.isBlockingSynchronousMethod() || returnType != Void.TYPE) {
                // empty if block
            }
            methodDescriptors.add(new MethodDescriptor(methodName, TurboModuleInteropUtils.createJniSignature(moduleName, methodName, paramClasses, returnType), TurboModuleInteropUtils.createJSIReturnKind(moduleName, methodName, paramClasses, returnType), TurboModuleInteropUtils.getJsArgCount(moduleName, methodName, paramClasses)));
        }
        return methodDescriptors;
    }

    private static Method[] getMethodsFromModule(NativeModule module) {
        Class<?> classForMethods = module.getClass();
        Class<?> superClass = classForMethods.getSuperclass();
        if (TurboModule.class.isAssignableFrom(superClass)) {
            classForMethods = superClass;
        }
        return classForMethods.getDeclaredMethods();
    }

    private static String createJniSignature(String moduleName, String methodName, Class<?>[] paramClasses, Class<?> returnClass) {
        StringBuilder jniSignature = new StringBuilder("(");
        for (Class<?> paramClass : paramClasses) {
            jniSignature.append(TurboModuleInteropUtils.convertParamClassToJniType(moduleName, methodName, paramClass));
        }
        jniSignature.append(")");
        jniSignature.append(TurboModuleInteropUtils.convertReturnClassToJniType(moduleName, methodName, returnClass));
        return jniSignature.toString();
    }

    private static String convertParamClassToJniType(String moduleName, String methodName, Class<?> paramClass) {
        if (paramClass == Boolean.TYPE) {
            return "Z";
        }
        if (paramClass == Integer.TYPE) {
            return "I";
        }
        if (paramClass == Double.TYPE) {
            return "D";
        }
        if (paramClass == Float.TYPE) {
            return "F";
        }
        if (paramClass == Boolean.class || paramClass == Integer.class || paramClass == Double.class || paramClass == Float.class || paramClass == String.class || paramClass == Callback.class || paramClass == Promise.class || paramClass == ReadableMap.class || paramClass == ReadableArray.class) {
            return TurboModuleInteropUtils.convertClassToJniType(paramClass);
        }
        if (paramClass == Dynamic.class) {
            // empty if block
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JNI signature. Detected unsupported parameter class: " + paramClass.getCanonicalName());
    }

    private static String convertReturnClassToJniType(String moduleName, String methodName, Class<?> returnClass) {
        if (returnClass == Boolean.TYPE) {
            return "Z";
        }
        if (returnClass == Integer.TYPE) {
            return "I";
        }
        if (returnClass == Double.TYPE) {
            return "D";
        }
        if (returnClass == Float.TYPE) {
            return "F";
        }
        if (returnClass == Void.TYPE) {
            return "V";
        }
        if (returnClass == Boolean.class || returnClass == Integer.class || returnClass == Double.class || returnClass == Float.class || returnClass == String.class || returnClass == WritableMap.class || returnClass == WritableArray.class || returnClass == Map.class) {
            return TurboModuleInteropUtils.convertClassToJniType(returnClass);
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JNI signature. Detected unsupported return class: " + returnClass.getCanonicalName());
    }

    private static String convertClassToJniType(Class<?> cls) {
        return 'L' + cls.getCanonicalName().replace('.', '/') + ';';
    }

    private static int getJsArgCount(String moduleName, String methodName, Class<?>[] paramClasses) {
        for (int i = 0; i < paramClasses.length; ++i) {
            if (paramClasses[i] != Promise.class) continue;
            if (i != paramClasses.length - 1) {
                throw new ParsingException(moduleName, methodName, "Unable to parse JavaScript arg count. Promises must be used as last parameter only.");
            }
            return paramClasses.length - 1;
        }
        return paramClasses.length;
    }

    private static String createJSIReturnKind(String moduleName, String methodName, Class<?>[] paramClasses, Class<?> returnClass) {
        for (int i = 0; i < paramClasses.length; ++i) {
            if (paramClasses[i] != Promise.class) continue;
            if (i != paramClasses.length - 1) {
                throw new ParsingException(moduleName, methodName, "Unable to parse JSI return kind. Promises must be used as last parameter only.");
            }
            return "PromiseKind";
        }
        if (returnClass == Boolean.TYPE || returnClass == Boolean.class) {
            return "BooleanKind";
        }
        if (returnClass == Double.TYPE || returnClass == Double.class || returnClass == Float.TYPE || returnClass == Float.class || returnClass == Integer.TYPE || returnClass == Integer.class) {
            return "NumberKind";
        }
        if (returnClass == String.class) {
            return "StringKind";
        }
        if (returnClass == Void.TYPE) {
            return "VoidKind";
        }
        if (returnClass == WritableMap.class || returnClass == Map.class) {
            return "ObjectKind";
        }
        if (returnClass == WritableArray.class) {
            return "ArrayKind";
        }
        throw new ParsingException(moduleName, methodName, "Unable to parse JSI return kind. Detected unsupported return class: " + returnClass.getCanonicalName());
    }

    private static class ParsingException
    extends RuntimeException {
        ParsingException(String moduleName, String message) {
            super("Unable to parse @ReactMethod annotations from native module: " + moduleName + ". Details: " + message);
        }

        ParsingException(String moduleName, String methodName, String message) {
            super("Unable to parse @ReactMethod annotation from native module method: " + moduleName + "." + methodName + "(). Details: " + message);
        }
    }

    static class MethodDescriptor {
        @DoNotStrip
        public final String methodName;
        @DoNotStrip
        public final String jniSignature;
        @DoNotStrip
        public final String jsiReturnKind;
        @DoNotStrip
        public final int jsArgCount;

        MethodDescriptor(String methodName, String jniSignature, String jsiReturnKind, int jsArgCount) {
            this.methodName = methodName;
            this.jniSignature = jniSignature;
            this.jsiReturnKind = jsiReturnKind;
            this.jsArgCount = jsArgCount;
        }
    }
}

