/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaOnlyArray
implements ReadableArray,
WritableArray {
    private final List mBackingList;

    public static JavaOnlyArray from(List list) {
        return new JavaOnlyArray(list);
    }

    public static JavaOnlyArray of(Object ... values) {
        return new JavaOnlyArray(values);
    }

    public static JavaOnlyArray deepClone(ReadableArray ary) {
        JavaOnlyArray res = new JavaOnlyArray();
        int size = ary.size();
        block8: for (int i = 0; i < size; ++i) {
            ReadableType type = ary.getType(i);
            switch (type) {
                case Null: {
                    res.pushNull();
                    continue block8;
                }
                case Boolean: {
                    res.pushBoolean(ary.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    res.pushDouble(ary.getDouble(i));
                    continue block8;
                }
                case String: {
                    res.pushString(ary.getString(i));
                    continue block8;
                }
                case Map: {
                    res.pushMap(JavaOnlyMap.deepClone(ary.getMap(i)));
                    continue block8;
                }
                case Array: {
                    res.pushArray(JavaOnlyArray.deepClone(ary.getArray(i)));
                }
            }
        }
        return res;
    }

    private JavaOnlyArray(Object ... values) {
        this.mBackingList = Arrays.asList(values);
    }

    private JavaOnlyArray(List list) {
        this.mBackingList = new ArrayList(list);
    }

    public JavaOnlyArray() {
        this.mBackingList = new ArrayList();
    }

    @Override
    public int size() {
        return this.mBackingList.size();
    }

    @Override
    public boolean isNull(int index) {
        return this.mBackingList.get(index) == null;
    }

    @Override
    public double getDouble(int index) {
        return ((Number)this.mBackingList.get(index)).doubleValue();
    }

    @Override
    public int getInt(int index) {
        return ((Number)this.mBackingList.get(index)).intValue();
    }

    @Override
    @Nullable
    public String getString(int index) {
        return (String)this.mBackingList.get(index);
    }

    @Override
    public ReadableArray getArray(int index) {
        return (ReadableArray)this.mBackingList.get(index);
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.mBackingList.get(index);
    }

    @Override
    public ReadableMap getMap(int index) {
        return (ReadableMap)this.mBackingList.get(index);
    }

    @Override
    @NonNull
    public Dynamic getDynamic(int index) {
        return DynamicFromArray.create(this, index);
    }

    @Override
    @NonNull
    public ReadableType getType(int index) {
        Object object = this.mBackingList.get(index);
        if (object == null) {
            return ReadableType.Null;
        }
        if (object instanceof Boolean) {
            return ReadableType.Boolean;
        }
        if (object instanceof Double || object instanceof Float || object instanceof Integer) {
            return ReadableType.Number;
        }
        if (object instanceof String) {
            return ReadableType.String;
        }
        if (object instanceof ReadableArray) {
            return ReadableType.Array;
        }
        if (object instanceof ReadableMap) {
            return ReadableType.Map;
        }
        return null;
    }

    @Override
    public void pushBoolean(boolean value) {
        this.mBackingList.add(value);
    }

    @Override
    public void pushDouble(double value) {
        this.mBackingList.add(value);
    }

    @Override
    public void pushInt(int value) {
        this.mBackingList.add(new Double(value));
    }

    @Override
    public void pushString(@Nullable String value) {
        this.mBackingList.add(value);
    }

    @Override
    public void pushArray(@Nullable ReadableArray array) {
        this.mBackingList.add(array);
    }

    @Override
    public void pushMap(@Nullable ReadableMap map) {
        this.mBackingList.add(map);
    }

    @Override
    public void pushNull() {
        this.mBackingList.add(null);
    }

    @Override
    @NonNull
    public ArrayList<Object> toArrayList() {
        return new ArrayList<Object>(this.mBackingList);
    }

    public String toString() {
        return this.mBackingList.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaOnlyArray that = (JavaOnlyArray)o;
        return !(this.mBackingList != null ? !this.mBackingList.equals(that.mBackingList) : that.mBackingList != null);
    }

    public int hashCode() {
        return this.mBackingList != null ? this.mBackingList.hashCode() : 0;
    }
}

