/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class ObjectAnimatedNode
extends AnimatedNode {
    private static final String VALUE_KEY = "value";
    private static final String NODE_TAG_KEY = "nodeTag";
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final JavaOnlyMap mConfig;

    ObjectAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        this.mConfig = JavaOnlyMap.deepClone(config);
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
    }

    public void collectViewUpdates(String propKey, JavaOnlyMap propsMap) {
        ReadableType valueType = this.mConfig.getType(VALUE_KEY);
        if (valueType == ReadableType.Map) {
            propsMap.putMap(propKey, this.collectViewUpdatesHelper(this.mConfig.getMap(VALUE_KEY)));
        } else if (valueType == ReadableType.Array) {
            propsMap.putArray(propKey, this.collectViewUpdatesHelper(this.mConfig.getArray(VALUE_KEY)));
        } else {
            throw new IllegalArgumentException("Invalid value type for ObjectAnimatedNode");
        }
    }

    @Nullable
    private JavaOnlyArray collectViewUpdatesHelper(@Nullable ReadableArray source) {
        if (source == null) {
            return null;
        }
        JavaOnlyArray result = new JavaOnlyArray();
        block8: for (int i = 0; i < source.size(); ++i) {
            switch (source.getType(i)) {
                case Null: {
                    result.pushNull();
                    continue block8;
                }
                case Boolean: {
                    result.pushBoolean(source.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    result.pushDouble(source.getDouble(i));
                    continue block8;
                }
                case String: {
                    result.pushString(source.getString(i));
                    continue block8;
                }
                case Map: {
                    ReadableMap map = source.getMap(i);
                    if (map.hasKey(NODE_TAG_KEY) && map.getType(NODE_TAG_KEY) == ReadableType.Number) {
                        AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(map.getInt(NODE_TAG_KEY));
                        if (node == null) {
                            throw new IllegalArgumentException("Mapped value node does not exist");
                        }
                        if (node instanceof ValueAnimatedNode) {
                            ValueAnimatedNode valueAnimatedNode = (ValueAnimatedNode)node;
                            Object animatedObject = valueAnimatedNode.getAnimatedObject();
                            if (animatedObject instanceof Integer) {
                                result.pushInt((Integer)animatedObject);
                                continue block8;
                            }
                            if (animatedObject instanceof String) {
                                result.pushString((String)animatedObject);
                                continue block8;
                            }
                            result.pushDouble(valueAnimatedNode.getValue());
                            continue block8;
                        }
                        if (!(node instanceof ColorAnimatedNode)) continue block8;
                        result.pushInt(((ColorAnimatedNode)node).getColor());
                        continue block8;
                    }
                    result.pushMap(this.collectViewUpdatesHelper(source.getMap(i)));
                    continue block8;
                }
                case Array: {
                    result.pushArray(this.collectViewUpdatesHelper(source.getArray(i)));
                }
            }
        }
        return result;
    }

    @Nullable
    private JavaOnlyMap collectViewUpdatesHelper(@Nullable ReadableMap source) {
        if (source == null) {
            return null;
        }
        JavaOnlyMap result = new JavaOnlyMap();
        ReadableMapKeySetIterator iter = source.keySetIterator();
        block8: while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            switch (source.getType(propKey)) {
                case Null: {
                    result.putNull(propKey);
                    break;
                }
                case Boolean: {
                    result.putBoolean(propKey, source.getBoolean(propKey));
                    break;
                }
                case Number: {
                    result.putDouble(propKey, source.getDouble(propKey));
                    break;
                }
                case String: {
                    result.putString(propKey, source.getString(propKey));
                    break;
                }
                case Map: {
                    ReadableMap map = source.getMap(propKey);
                    if (map != null && map.hasKey(NODE_TAG_KEY) && map.getType(NODE_TAG_KEY) == ReadableType.Number) {
                        AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(map.getInt(NODE_TAG_KEY));
                        if (node == null) {
                            throw new IllegalArgumentException("Mapped value node does not exist");
                        }
                        if (node instanceof ValueAnimatedNode) {
                            ValueAnimatedNode valueAnimatedNode = (ValueAnimatedNode)node;
                            Object animatedObject = valueAnimatedNode.getAnimatedObject();
                            if (animatedObject instanceof Integer) {
                                result.putInt(propKey, (Integer)animatedObject);
                                break;
                            }
                            if (animatedObject instanceof String) {
                                result.putString(propKey, (String)animatedObject);
                                break;
                            }
                            result.putDouble(propKey, valueAnimatedNode.getValue());
                            break;
                        }
                        if (!(node instanceof ColorAnimatedNode)) continue block8;
                        result.putInt(propKey, ((ColorAnimatedNode)node).getColor());
                        break;
                    }
                    result.putMap(propKey, this.collectViewUpdatesHelper(map));
                    break;
                }
                case Array: {
                    result.putArray(propKey, this.collectViewUpdatesHelper(source.getArray(propKey)));
                }
            }
        }
        return result;
    }

    @Override
    public String prettyPrint() {
        return "ObjectAnimatedNode[" + this.mTag + "]: mConfig: " + (this.mConfig != null ? this.mConfig.toString() : "null");
    }
}

