/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactDelegate;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;

public class ReactFragment
extends Fragment
implements PermissionAwareActivity {
    protected static final String ARG_COMPONENT_NAME = "arg_component_name";
    protected static final String ARG_LAUNCH_OPTIONS = "arg_launch_options";
    protected static final String ARG_FABRIC_ENABLED = "arg_fabric_enabled";
    protected ReactDelegate mReactDelegate;
    @Nullable
    private PermissionListener mPermissionListener;

    private static ReactFragment newInstance(String componentName, Bundle launchOptions, Boolean fabricEnabled) {
        ReactFragment fragment = new ReactFragment();
        Bundle args = new Bundle();
        args.putString(ARG_COMPONENT_NAME, componentName);
        args.putBundle(ARG_LAUNCH_OPTIONS, launchOptions);
        args.putBoolean(ARG_FABRIC_ENABLED, fabricEnabled.booleanValue());
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String mainComponentName = null;
        Bundle launchOptions = null;
        Boolean fabricEnabled = null;
        if (this.getArguments() != null) {
            mainComponentName = this.getArguments().getString(ARG_COMPONENT_NAME);
            launchOptions = this.getArguments().getBundle(ARG_LAUNCH_OPTIONS);
            fabricEnabled = this.getArguments().getBoolean(ARG_FABRIC_ENABLED);
        }
        if (mainComponentName == null) {
            throw new IllegalStateException("Cannot loadApp if component name is null");
        }
        this.mReactDelegate = new ReactDelegate((Activity)this.getActivity(), this.getReactNativeHost(), mainComponentName, launchOptions, fabricEnabled);
    }

    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getActivity().getApplication()).getReactNativeHost();
    }

    protected ReactDelegate getReactDelegate() {
        return this.mReactDelegate;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mReactDelegate.loadApp();
        return this.mReactDelegate.getReactRootView();
    }

    public void onResume() {
        super.onResume();
        this.mReactDelegate.onHostResume();
    }

    public void onPause() {
        super.onPause();
        this.mReactDelegate.onHostPause();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mReactDelegate.onHostDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mReactDelegate.onActivityResult(requestCode, resultCode, data, false);
    }

    public boolean onBackPressed() {
        return this.mReactDelegate.onBackPressed();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mReactDelegate.shouldShowDevMenuOrReload(keyCode, event);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionListener != null && this.mPermissionListener.onRequestPermissionsResult(requestCode, permissions, grantResults)) {
            this.mPermissionListener = null;
        }
    }

    @Override
    public int checkPermission(String permission, int pid, int uid) {
        return this.getActivity().checkPermission(permission, pid, uid);
    }

    @Override
    public int checkSelfPermission(String permission) {
        return this.getActivity().checkSelfPermission(permission);
    }

    @Override
    public void requestPermissions(String[] permissions, int requestCode, PermissionListener listener) {
        this.mPermissionListener = listener;
        this.requestPermissions(permissions, requestCode);
    }

    public static class Builder {
        @Nullable
        String mComponentName = null;
        @Nullable
        Bundle mLaunchOptions = null;
        @Nullable
        Boolean mFabricEnabled = false;

        public Builder setComponentName(String componentName) {
            this.mComponentName = componentName;
            return this;
        }

        public Builder setLaunchOptions(Bundle launchOptions) {
            this.mLaunchOptions = launchOptions;
            return this;
        }

        public ReactFragment build() {
            return ReactFragment.newInstance(this.mComponentName, this.mLaunchOptions, this.mFabricEnabled);
        }

        public Builder setFabricEnabled(boolean fabricEnabled) {
            this.mFabricEnabled = fabricEnabled;
            return this;
        }
    }
}

