/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.Nullable;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.debuggingoverlay.DebuggingOverlayManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;

public class DebugCorePackage
extends TurboReactPackage
implements ViewManagerOnDemandReactPackage {
    @Nullable
    private Map<String, ModuleSpec> mViewManagers;

    @Override
    @Nullable
    public NativeModule getModule(String name, ReactApplicationContext reactContext) {
        switch (name) {
            case "JSCHeapCapture": {
                return new JSCHeapCapture(reactContext);
            }
        }
        return null;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        try {
            Class<?> reactModuleInfoProviderClass = Class.forName("com.facebook.react.DebugCorePackage$$ReactModuleInfoProvider");
            return (ReactModuleInfoProvider)reactModuleInfoProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Class[] moduleList = new Class[]{JSCHeapCapture.class};
            HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
            for (Class moduleClass : moduleList) {
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                reactModuleInfoMap.put(reactModule.name(), new ReactModuleInfo(reactModule.name(), moduleClass.getName(), reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), ReactModuleInfo.classIsTurboModule(moduleClass)));
            }
            return () -> reactModuleInfoMap;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for DebugCorePackage$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for DebugCorePackage$$ReactModuleInfoProvider", e);
        }
    }

    private static void appendMap(Map<String, ModuleSpec> map, String name, Provider<? extends NativeModule> provider) {
        map.put(name, ModuleSpec.viewManagerSpec(provider));
    }

    private Map<String, ModuleSpec> getViewManagersMap() {
        if (this.mViewManagers == null) {
            HashMap<String, ModuleSpec> viewManagers = new HashMap<String, ModuleSpec>();
            DebugCorePackage.appendMap(viewManagers, "DebuggingOverlay", (Provider<? extends NativeModule>)((Provider)DebuggingOverlayManager::new));
            this.mViewManagers = viewManagers;
        }
        return this.mViewManagers;
    }

    @Override
    public List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return new ArrayList<ModuleSpec>(this.getViewManagersMap().values());
    }

    @Override
    public Collection<String> getViewManagerNames(ReactApplicationContext reactContext) {
        return this.getViewManagersMap().keySet();
    }

    @Override
    @Nullable
    public ViewManager createViewManager(ReactApplicationContext reactContext, String viewManagerName) {
        ModuleSpec spec = this.getViewManagersMap().get(viewManagerName);
        return spec != null ? (ViewManager)spec.getProvider().get() : null;
    }
}

