/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.util.ULocale;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.UnicodeExtensionKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class LocaleObjectICU
implements ILocaleObject<ULocale> {
    private ULocale m_icuLocale = null;
    private ULocale.Builder m_icuLocaleBuilder = null;
    private boolean mIsDirty = false;

    private LocaleObjectICU(ULocale uLocale) {
        assert (Build.VERSION.SDK_INT >= 24);
        this.m_icuLocale = uLocale;
    }

    @RequiresApi(api=24)
    private LocaleObjectICU(String localeId) throws JSRangeErrorException {
        assert (Build.VERSION.SDK_INT >= 24);
        this.m_icuLocaleBuilder = new ULocale.Builder();
        try {
            this.m_icuLocaleBuilder.setLanguageTag(localeId);
        }
        catch (RuntimeException ex) {
            throw new JSRangeErrorException(ex.getMessage());
        }
        this.mIsDirty = true;
    }

    @RequiresApi(api=24)
    private void ensureNotDirty() throws JSRangeErrorException {
        if (this.mIsDirty) {
            try {
                this.m_icuLocale = this.m_icuLocaleBuilder.build();
            }
            catch (RuntimeException ex) {
                throw new JSRangeErrorException(ex.getMessage());
            }
            this.mIsDirty = false;
        }
    }

    @Override
    @RequiresApi(api=24)
    public ArrayList<String> getUnicodeExtensions(String key) throws JSRangeErrorException {
        this.ensureNotDirty();
        String icuKey = UnicodeExtensionKeys.CanonicalKeyToICUKey(key);
        ArrayList<String> extensionList = new ArrayList<String>();
        String keywordValue = this.m_icuLocale.getKeywordValue(icuKey);
        if (keywordValue != null && !keywordValue.isEmpty()) {
            Collections.addAll(extensionList, keywordValue.split("-|_"));
        }
        return extensionList;
    }

    @Override
    @RequiresApi(api=24)
    public HashMap<String, String> getUnicodeExtensions() throws JSRangeErrorException {
        this.ensureNotDirty();
        HashMap<String, String> keywordMap = new HashMap<String, String>();
        Iterator keywords = this.m_icuLocale.getKeywords();
        if (keywords != null) {
            while (keywords.hasNext()) {
                String keyword = (String)keywords.next();
                String canonicalKeyword = UnicodeExtensionKeys.ICUKeyToCanonicalKey(keyword);
                String value = this.m_icuLocale.getKeywordValue(keyword);
                keywordMap.put(canonicalKeyword, value);
            }
        }
        return keywordMap;
    }

    @Override
    @RequiresApi(api=24)
    public void setUnicodeExtensions(String key, ArrayList<String> value) throws JSRangeErrorException {
        this.ensureNotDirty();
        if (this.m_icuLocaleBuilder == null) {
            this.m_icuLocaleBuilder = new ULocale.Builder().setLocale(this.m_icuLocale);
        }
        try {
            this.m_icuLocaleBuilder.setUnicodeLocaleKeyword(key, TextUtils.join((CharSequence)"-", value));
        }
        catch (RuntimeException ex) {
            throw new JSRangeErrorException(ex.getMessage());
        }
        this.mIsDirty = true;
    }

    @Override
    @RequiresApi(api=24)
    public ULocale getLocale() throws JSRangeErrorException {
        this.ensureNotDirty();
        return this.m_icuLocale;
    }

    @Override
    @RequiresApi(api=24)
    public ULocale getLocaleWithoutExtensions() throws JSRangeErrorException {
        this.ensureNotDirty();
        ULocale.Builder localeBuilder = new ULocale.Builder();
        localeBuilder.setLocale(this.m_icuLocale);
        localeBuilder.clearExtensions();
        return localeBuilder.build();
    }

    @Override
    @RequiresApi(api=24)
    public String toCanonicalTag() throws JSRangeErrorException {
        return this.getLocale().toLanguageTag();
    }

    @Override
    @RequiresApi(api=24)
    public String toCanonicalTagWithoutExtensions() throws JSRangeErrorException {
        return this.getLocaleWithoutExtensions().toLanguageTag();
    }

    @Override
    @RequiresApi(api=24)
    public ILocaleObject<ULocale> cloneObject() throws JSRangeErrorException {
        this.ensureNotDirty();
        return new LocaleObjectICU(this.m_icuLocale);
    }

    @RequiresApi(api=24)
    public static ILocaleObject<ULocale> createFromLocaleId(String localeId) throws JSRangeErrorException {
        return new LocaleObjectICU(localeId);
    }

    public static ILocaleObject<ULocale> createFromULocale(ULocale uLocale) {
        return new LocaleObjectICU(uLocale);
    }

    @RequiresApi(api=24)
    public static ILocaleObject<ULocale> createDefault() {
        return new LocaleObjectICU(ULocale.getDefault((ULocale.Category)ULocale.Category.FORMAT));
    }
}

