/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockUtil;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class IntArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntArrayBlock.class).instanceSize();
    public static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final int[] values;
    private final long retainedSizeInBytes;

    public IntArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, int[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    IntArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, int[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])values);
    }

    @Override
    public long getSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(5);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] usedPositions, int usedPositionCount) {
        return 5L * (long)usedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 4L;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((int[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getInt(int position) {
        this.checkReadablePosition(position);
        return this.getIntUnchecked(position + this.arrayOffset);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.isNullUnchecked(position + this.arrayOffset);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeInt(this.values[position + this.arrayOffset]);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            output.writeInt(this.values[position + this.arrayOffset]);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new IntArrayBlock(0, 1, blArray, new int[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new IntArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.arrayOffset, length);
        int[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "INT_ARRAY";
    }

    public String toString() {
        return String.format("IntArrayBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.values[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] newValueIsNull = BlockUtil.appendNullToIsNullArray(this.valueIsNull, this.arrayOffset, this.positionCount);
        int[] newValues = com.facebook.presto.common.array.Arrays.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1, Arrays.ExpansionFactor.SMALL, Arrays.ExpansionOption.PRESERVE);
        return new IntArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayBlock that = (IntArrayBlock)o;
        return this.arrayOffset == that.arrayOffset && this.positionCount == that.positionCount && this.retainedSizeInBytes == that.retainedSizeInBytes && Arrays.equals(this.valueIsNull, that.valueIsNull) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.arrayOffset, this.positionCount, this.retainedSizeInBytes);
        result = 31 * result + Arrays.hashCode(this.valueIsNull);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

