/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.EncoderUtil;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class ByteArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "BYTE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < positionCount; ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            sliceOutput.writeByte((int)block.getByte(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        byte[] values = new byte[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(values, 0, values.length);
        } else {
            for (int position = 0; position < values.length; ++position) {
                if (valueIsNull[position]) continue;
                values[position] = sliceInput.readByte();
            }
        }
        return new ByteArrayBlock(0, positionCount, valueIsNull, values);
    }
}

