/*
 * Copyright (c) 2017 - present Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package com.facebook.infer.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Tell the analysis that a collection is thread-safe when this information is not already
 * reflected in the collection's type. For example:
 * private {@literal @SynchronizedCollection} Map mMap = Collections.synchronizedMap(...);
 */

@Target({ ElementType.FIELD })
@Retention(RetentionPolicy.CLASS)
public @interface SynchronizedCollection {
}
