/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.lazy.OrcLazyList;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;

public class OrcLazyListObjectInspector
implements ListObjectInspector {
    private final ObjectInspector child;

    public OrcLazyListObjectInspector(ListTypeInfo info) {
        this.child = OrcLazyObjectInspectorUtils.createWritableObjectInspector(info.getListElementTypeInfo());
    }

    public OrcLazyListObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        this.child = OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(0), types);
    }

    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        try {
            return (List)((OrcLazyList)data).materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        return this.getList(data).get(index);
    }

    public ObjectInspector getListElementObjectInspector() {
        return this.child;
    }

    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        return this.getList(data).size();
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    public String getTypeName() {
        return "array<" + this.child.getTypeName() + ">";
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ObjectInspector other = ((OrcLazyListObjectInspector)o).child;
        return other.equals(this.child);
    }
}

