/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.SerializationUtils;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

public class LazyDoubleTreeReader
extends LazyTreeReader {
    private InStream stream;
    private double latestRead = 0.0;

    public LazyDoubleTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
        this.stream = streams.get(name);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.stream.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.stream.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    private double readDouble() throws IOException {
        this.latestRead = SerializationUtils.readDouble(this.stream);
        return this.latestRead;
    }

    DoubleWritable createWritable(Object previous, double v) throws IOException {
        DoubleWritable result = null;
        result = previous == null ? new DoubleWritable() : (DoubleWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public double nextDouble(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize double.");
        }
        return this.readDouble();
    }

    @Override
    public Object next(Object previous) throws IOException {
        DoubleWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readDouble());
        }
        return result;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.stream.skip(numNonNullValues * 8L);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

