/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.DictionaryEncoder;
import com.facebook.hive.orc.DynamicByteArray;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.Text;

class StringDictionaryEncoder
extends DictionaryEncoder {
    private final DynamicByteArray byteArray = new DynamicByteArray();
    private int[] offsets = new int[32768];
    private int[] hashcodes = new int[32768];
    private int[] nexts = new int[32768];
    private int[] counts = new int[32768];
    private int[] indexStrides = new int[32768];
    private final TextCompressedHashSet htDictionary = new TextCompressedHashSet();
    private int numElements = 0;
    private final boolean sortByStride;

    public StringDictionaryEncoder() {
        this.sortByStride = false;
    }

    public StringDictionaryEncoder(boolean sortKeys, boolean sortByStride) {
        super(sortKeys);
        this.sortByStride = sortByStride;
    }

    public int add(Text value, int indexStride) {
        int len = value.getLength();
        int newKeyIndex = this.numElements + 1;
        this.hashcodes[newKeyIndex] = value.hashCode();
        Slice newKeySlice = Slices.wrappedBuffer((byte[])value.getBytes(), (int)0, (int)value.getLength());
        int existing = this.htDictionary.add(newKeySlice, newKeyIndex);
        if (existing != 0) {
            return existing - 1;
        }
        int valRow = this.numElements++;
        if (newKeyIndex + 1 >= this.offsets.length) {
            this.offsets = this.getDoubleSizeArray(this.offsets);
            this.hashcodes = this.getDoubleSizeArray(this.hashcodes);
            this.nexts = this.getDoubleSizeArray(this.nexts);
            this.counts = this.getDoubleSizeArray(this.counts);
            this.indexStrides = this.getDoubleSizeArray(this.indexStrides);
        }
        this.offsets[newKeyIndex] = this.byteArray.add(value.getBytes(), 0, len);
        this.indexStrides[newKeyIndex] = indexStride;
        return valRow;
    }

    private int[] getDoubleSizeArray(int[] array) {
        int[] newArray = new int[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private int getEnd(int pos) {
        if (pos + 1 > this.numElements) {
            return this.byteArray.size();
        }
        return this.offsets[pos + 1];
    }

    protected boolean equalsValue(Slice key, int offset, int length) {
        return this.byteArray.equals(key, 0, key.length(), offset, length);
    }

    private void visitDictionary(DictionaryEncoder.Visitor<Text> visitor, VisitorContextImpl context) throws IOException {
        int[] keysArray = null;
        if (this.sortKeys) {
            keysArray = new int[this.numElements];
            for (int idx = 0; idx < this.numElements; ++idx) {
                keysArray[idx] = idx + 1;
            }
            IntArrays.quickSort((int[])keysArray, (IntComparator)new TextPositionComparator());
        }
        for (int pos = 0; pos < this.numElements; ++pos) {
            context.setOriginalPosition(keysArray == null ? pos + 1 : keysArray[pos]);
            visitor.visit(context);
        }
        keysArray = null;
    }

    public void visit(DictionaryEncoder.Visitor<Text> visitor) throws IOException {
        this.visitDictionary(visitor, new VisitorContextImpl());
    }

    public void getText(Text result, int originalPosition) {
        this.byteArray.setText(result, this.offsets[originalPosition + 1], this.getEnd(originalPosition + 1) - this.offsets[originalPosition + 1]);
    }

    @Override
    public void clear() {
        this.byteArray.clear();
        this.htDictionary.clear();
        this.offsets = new int[32768];
        this.hashcodes = new int[32768];
        this.nexts = new int[32768];
        this.counts = new int[32768];
        this.indexStrides = new int[32768];
        this.numElements = 0;
    }

    public long getCharacterSize() {
        return this.byteArray.getSizeInBytes();
    }

    @Override
    public int getUncompressedLength() {
        return this.byteArray.size();
    }

    public long getSizeInBytes() {
        long refSizes = this.htDictionary.size() * 4;
        long textCompressedSizes = this.offsets.length * 4 + this.hashcodes.length * 4 + this.nexts.length * 4 + this.counts.length * 4 + this.indexStrides.length * 4;
        long totalSize = this.getCharacterSize();
        return totalSize += refSizes + textCompressedSizes;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    private class VisitorContextImpl
    implements DictionaryEncoder.VisitorContext<Text> {
        private int originalPosition;
        private int start;
        private int length;
        private int count;
        private int indexStride;
        private final Text text = new Text();

        private VisitorContextImpl() {
        }

        public void setOriginalPosition(int pos) {
            this.originalPosition = pos - 1;
            this.start = StringDictionaryEncoder.this.offsets[pos];
            this.length = StringDictionaryEncoder.this.getEnd(pos) - StringDictionaryEncoder.this.offsets[pos];
            this.count = StringDictionaryEncoder.this.counts[pos];
            this.indexStride = StringDictionaryEncoder.this.indexStrides[pos];
        }

        @Override
        public int getOriginalPosition() {
            return this.originalPosition;
        }

        @Override
        public Text getKey() {
            StringDictionaryEncoder.this.byteArray.setText(this.text, this.start, this.length);
            return this.text;
        }

        @Override
        public void writeBytes(OutputStream out) throws IOException {
            StringDictionaryEncoder.this.byteArray.write(out, this.start, this.length);
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getIndexStride() {
            return this.indexStride;
        }
    }

    public class TextPositionComparator
    implements IntComparator {
        public int compare(Integer k1, Integer k2) {
            return this.compare((int)k1, (int)k2);
        }

        public int compare(int k1, int k2) {
            if (StringDictionaryEncoder.this.sortByStride) {
                if (!(StringDictionaryEncoder.this.counts[k1] != 1 && StringDictionaryEncoder.this.counts[k2] != 1 || StringDictionaryEncoder.this.counts[k1] == 1 && StringDictionaryEncoder.this.counts[k2] == 1)) {
                    return Ints.compare((int)StringDictionaryEncoder.this.counts[k1], (int)StringDictionaryEncoder.this.counts[k2]);
                }
                if (StringDictionaryEncoder.this.counts[k1] == 1 && StringDictionaryEncoder.this.counts[k2] == 1 && StringDictionaryEncoder.this.indexStrides[k1] != StringDictionaryEncoder.this.indexStrides[k2]) {
                    return Ints.compare((int)StringDictionaryEncoder.this.indexStrides[k1], (int)StringDictionaryEncoder.this.indexStrides[k2]);
                }
            }
            int k1Length = StringDictionaryEncoder.this.getEnd(k1) - StringDictionaryEncoder.this.offsets[k1];
            int k2Length = StringDictionaryEncoder.this.getEnd(k2) - StringDictionaryEncoder.this.offsets[k2];
            return StringDictionaryEncoder.this.byteArray.compare(StringDictionaryEncoder.this.offsets[k1], k1Length, StringDictionaryEncoder.this.offsets[k2], k2Length);
        }
    }

    private class TextCompressedHashSet {
        private int mask;
        private int[] key;
        private int numValues;
        private int maxFill;
        private int length = HashCommon.arraySize((int)128, (float)0.75f);
        private static final float LOAD_FACTOR = 0.75f;
        private static final int MIN_EXPECTED = 128;

        public TextCompressedHashSet() {
            this.mask = this.length - 1;
            this.maxFill = HashCommon.maxFill((int)this.length, (float)0.75f);
            this.key = new int[this.length];
        }

        public int add(Slice newKey, int k) {
            int pos = HashCommon.murmurHash3((int)StringDictionaryEncoder.this.hashcodes[k]) & this.mask;
            int other = this.key[pos];
            int prev = 0;
            while (other != 0) {
                if (StringDictionaryEncoder.this.hashcodes[k] == StringDictionaryEncoder.this.hashcodes[other] && StringDictionaryEncoder.this.equalsValue(newKey, StringDictionaryEncoder.this.offsets[other], StringDictionaryEncoder.this.getEnd(other) - StringDictionaryEncoder.this.offsets[other])) {
                    if (other != this.key[pos]) {
                        ((StringDictionaryEncoder)StringDictionaryEncoder.this).nexts[prev] = StringDictionaryEncoder.this.nexts[other];
                        ((StringDictionaryEncoder)StringDictionaryEncoder.this).nexts[other] = this.key[pos];
                        this.key[pos] = other;
                    }
                    int[] nArray = StringDictionaryEncoder.this.counts;
                    int n = other;
                    nArray[n] = nArray[n] + 1;
                    return other;
                }
                prev = other;
                other = StringDictionaryEncoder.this.nexts[other];
            }
            ((StringDictionaryEncoder)StringDictionaryEncoder.this).nexts[k] = this.key[pos];
            this.key[pos] = k;
            ((StringDictionaryEncoder)StringDictionaryEncoder.this).counts[k] = 1;
            if (++this.numValues >= this.maxFill) {
                this.rehash(HashCommon.arraySize((int)(this.numValues + 1), (float)0.75f));
            }
            return 0;
        }

        private void rehash(int newN) {
            int i = 0;
            int[] key = this.key;
            int newMask = newN - 1;
            int[] newKey = new int[newN];
            int j = this.numValues;
            while (j != 0) {
                int next;
                int k;
                while ((k = key[i]) == 0) {
                    ++i;
                }
                do {
                    int pos = HashCommon.murmurHash3((int)StringDictionaryEncoder.this.hashcodes[k]) & newMask;
                    next = StringDictionaryEncoder.this.nexts[k];
                    ((StringDictionaryEncoder)StringDictionaryEncoder.this).nexts[k] = newKey[pos];
                    newKey[pos] = k;
                    --j;
                } while ((k = next) != 0);
                ++i;
            }
            this.length = newN;
            this.mask = newMask;
            this.maxFill = HashCommon.maxFill((int)this.length, (float)0.75f);
            this.key = newKey;
        }

        public void clear() {
            if (this.numValues == 0) {
                return;
            }
            this.numValues = 0;
            for (int i = 0; i < this.length; ++i) {
                this.key[i] = 0;
            }
        }

        public int size() {
            return this.numValues;
        }
    }
}

