/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.ColumnStatistics;
import com.facebook.hive.orc.CompressionKind;
import com.facebook.hive.orc.OrcFile;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.RecordReaderImpl;
import com.facebook.hive.orc.StripeInformation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class FileDump {
    private FileDump() {
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        for (String filename : args) {
            System.out.println("Structure for " + filename);
            Path path = new Path(filename);
            Reader reader = OrcFile.createReader(path.getFileSystem(conf), path, conf);
            RecordReaderImpl rows = (RecordReaderImpl)reader.rows(null);
            System.out.println("Rows: " + reader.getNumberOfRows());
            System.out.println("Compression: " + (Object)((Object)reader.getCompression()));
            if (reader.getCompression() != CompressionKind.NONE) {
                System.out.println("Compression size: " + reader.getCompressionSize());
            }
            System.out.println("Raw data size: " + reader.getRawDataSize());
            System.out.println("Type: " + reader.getObjectInspector().getTypeName());
            ColumnStatistics[] stats = reader.getStatistics();
            System.out.println("\nStatistics:");
            for (int i = 0; i < stats.length; ++i) {
                System.out.println("  Column " + i + ": " + stats[i].toString());
            }
            System.out.println("\nStripes:");
            for (StripeInformation stripe : reader.getStripes()) {
                long stripeStart = stripe.getOffset();
                System.out.println("  Stripe: " + stripe.toString());
                OrcProto.StripeFooter footer = rows.readStripeFooter(stripe);
                long sectionStart = stripeStart;
                for (OrcProto.Stream section : footer.getStreamsList()) {
                    System.out.println("    Stream: column " + section.getColumn() + " section " + section.getKind() + " start: " + sectionStart + " length " + section.getLength());
                    sectionStart += section.getLength();
                }
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    StringBuilder buf = new StringBuilder();
                    buf.append("    Encoding column ");
                    buf.append(i);
                    buf.append(": ");
                    buf.append(encoding.getKind());
                    if (encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY) {
                        buf.append("[");
                        buf.append(encoding.getDictionarySize());
                        buf.append("]");
                    }
                    System.out.println(buf);
                }
            }
        }
    }
}

