/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.ui.common;

import com.facebook.fresco.ui.common.ControllerListener2;
import com.facebook.fresco.ui.common.DimensionsInfo;
import com.facebook.fresco.ui.common.ImageLoadStatus;
import com.facebook.fresco.ui.common.ImagePerfData;
import com.facebook.fresco.ui.common.VisibilityState;
import com.facebook.infer.annotation.Nullsafe;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ImagePerfState {
    @Nullable
    private String mControllerId;
    @Nullable
    private String mRequestId;
    @Nullable
    private Object mImageRequest;
    @Nullable
    private Object mCallerContext;
    @Nullable
    private Object mImageInfo;
    private long mControllerSubmitTimeMs = -1L;
    private long mControllerIntermediateImageSetTimeMs = -1L;
    private long mControllerFinalImageSetTimeMs = -1L;
    private long mControllerFailureTimeMs = -1L;
    private long mControllerCancelTimeMs = -1L;
    private long mImageRequestStartTimeMs = -1L;
    private long mImageRequestEndTimeMs = -1L;
    @Nullable
    private String mUltimateProducerName;
    private boolean mIsPrefetch;
    private int mOnScreenWidthPx = -1;
    private int mOnScreenHeightPx = -1;
    @Nullable
    private Throwable mErrorThrowable;
    private ImageLoadStatus mImageLoadStatus = ImageLoadStatus.UNKNOWN;
    private VisibilityState mVisibilityState = VisibilityState.UNKNOWN;
    private long mVisibilityEventTimeMs = -1L;
    private long mInvisibilityEventTimeMs = -1L;
    private long mImageDrawTimeMs = -1L;
    @Nullable
    private String mComponentTag;
    @Nullable
    private DimensionsInfo mDimensionsInfo;
    @Nullable
    private ControllerListener2.Extras mExtraData;
    private final Map<String, Object> mPipelineExtras = new HashMap<String, Object>();

    public void reset() {
        this.mRequestId = null;
        this.mImageRequest = null;
        this.mCallerContext = null;
        this.mImageInfo = null;
        this.mUltimateProducerName = null;
        this.mIsPrefetch = false;
        this.mOnScreenWidthPx = -1;
        this.mOnScreenHeightPx = -1;
        this.mErrorThrowable = null;
        this.mImageLoadStatus = ImageLoadStatus.UNKNOWN;
        this.mVisibilityState = VisibilityState.UNKNOWN;
        this.mComponentTag = null;
        this.mDimensionsInfo = null;
        this.mExtraData = null;
        this.mPipelineExtras.clear();
        this.resetPointsTimestamps();
    }

    public void resetPointsTimestamps() {
        this.mImageRequestStartTimeMs = -1L;
        this.mImageRequestEndTimeMs = -1L;
        this.mControllerSubmitTimeMs = -1L;
        this.mControllerFinalImageSetTimeMs = -1L;
        this.mControllerFailureTimeMs = -1L;
        this.mControllerCancelTimeMs = -1L;
        this.mVisibilityEventTimeMs = -1L;
        this.mInvisibilityEventTimeMs = -1L;
        this.mImageDrawTimeMs = -1L;
    }

    public void setImageLoadStatus(ImageLoadStatus imageLoadStatus) {
        this.mImageLoadStatus = imageLoadStatus;
    }

    public ImageLoadStatus getImageLoadStatus() {
        return this.mImageLoadStatus;
    }

    public void setControllerId(@Nullable String controllerId) {
        this.mControllerId = controllerId;
    }

    public void setRequestId(@Nullable String requestId) {
        this.mRequestId = requestId;
    }

    public void setImageRequest(@Nullable Object imageRequest) {
        this.mImageRequest = imageRequest;
    }

    public void setCallerContext(@Nullable Object callerContext) {
        this.mCallerContext = callerContext;
    }

    public void setControllerSubmitTimeMs(long controllerSubmitTimeMs) {
        this.mControllerSubmitTimeMs = controllerSubmitTimeMs;
    }

    public void setControllerIntermediateImageSetTimeMs(long controllerIntermediateImageSetTimeMs) {
        this.mControllerIntermediateImageSetTimeMs = controllerIntermediateImageSetTimeMs;
    }

    public void setControllerFinalImageSetTimeMs(long controllerFinalImageSetTimeMs) {
        this.mControllerFinalImageSetTimeMs = controllerFinalImageSetTimeMs;
    }

    public void setControllerFailureTimeMs(long controllerFailureTimeMs) {
        this.mControllerFailureTimeMs = controllerFailureTimeMs;
    }

    public void setControllerCancelTimeMs(long controllerCancelTimeMs) {
        this.mControllerCancelTimeMs = controllerCancelTimeMs;
    }

    public void setImageRequestStartTimeMs(long imageRequestStartTimeMs) {
        this.mImageRequestStartTimeMs = imageRequestStartTimeMs;
    }

    public void setImageRequestEndTimeMs(long imageRequestEndTimeMs) {
        this.mImageRequestEndTimeMs = imageRequestEndTimeMs;
    }

    public void setVisibilityEventTimeMs(long visibilityEventTimeMs) {
        this.mVisibilityEventTimeMs = visibilityEventTimeMs;
    }

    public void setInvisibilityEventTimeMs(long invisibilityEventTimeMs) {
        this.mInvisibilityEventTimeMs = invisibilityEventTimeMs;
    }

    public void setUltimateProducerName(@Nullable String ultimateProducerName) {
        this.mUltimateProducerName = ultimateProducerName;
    }

    public void setPrefetch(boolean prefetch) {
        this.mIsPrefetch = prefetch;
    }

    public void setImageInfo(@Nullable Object imageInfo) {
        this.mImageInfo = imageInfo;
    }

    public void setOnScreenWidth(int onScreenWidthPx) {
        this.mOnScreenWidthPx = onScreenWidthPx;
    }

    public void setOnScreenHeight(int onScreenHeightPx) {
        this.mOnScreenHeightPx = onScreenHeightPx;
    }

    public void setErrorThrowable(@Nullable Throwable errorThrowable) {
        this.mErrorThrowable = errorThrowable;
    }

    public void setVisible(boolean visible) {
        this.mVisibilityState = visible ? VisibilityState.VISIBLE : VisibilityState.INVISIBLE;
    }

    public void setComponentTag(@Nullable String componentTag) {
        this.mComponentTag = componentTag;
    }

    public void setImageDrawTimeMs(long imageDrawTimeMs) {
        this.mImageDrawTimeMs = imageDrawTimeMs;
    }

    public ImagePerfData snapshot() {
        return new ImagePerfData(this.mControllerId, this.mRequestId, this.mImageRequest, this.mCallerContext, this.mImageInfo, this.mControllerSubmitTimeMs, this.mControllerIntermediateImageSetTimeMs, this.mControllerFinalImageSetTimeMs, this.mControllerFailureTimeMs, this.mControllerCancelTimeMs, this.mImageRequestStartTimeMs, this.mImageRequestEndTimeMs, this.mUltimateProducerName, this.mIsPrefetch, this.mOnScreenWidthPx, this.mOnScreenHeightPx, this.mErrorThrowable, this.mVisibilityState, this.mVisibilityEventTimeMs, this.mInvisibilityEventTimeMs, this.mComponentTag, this.mImageDrawTimeMs, this.mDimensionsInfo, this.mExtraData, this.mPipelineExtras);
    }

    public long getImageDrawTimeMs() {
        return this.mImageDrawTimeMs;
    }

    public void setDimensionsInfo(DimensionsInfo dimensionsInfo) {
        this.mDimensionsInfo = dimensionsInfo;
    }

    @Nullable
    public DimensionsInfo getDimensionsInfo() {
        return this.mDimensionsInfo;
    }

    public void setExtraData(@Nullable ControllerListener2.Extras extraData) {
        this.mExtraData = extraData;
    }

    @Nullable
    public Object getExtraData() {
        return this.mExtraData;
    }

    public void setPipelineExtra(String key, @Nullable Object value) {
        this.mPipelineExtras.put(key, value);
    }

    @Nullable
    public Object getPipelineExtra(String key) {
        if (this.mPipelineExtras.containsKey(key)) {
            return this.mPipelineExtras.get(key);
        }
        return null;
    }
}

