/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.ui.common;

import android.net.Uri;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.PropagatesNullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public interface ControllerListener2<INFO> {
    public void onSubmit(String var1, @Nullable Object var2, @Nullable Extras var3);

    public void onFinalImageSet(String var1, @Nullable INFO var2, @Nullable Extras var3);

    public void onIntermediateImageSet(String var1, @Nullable INFO var2);

    public void onIntermediateImageFailed(String var1);

    public void onFailure(String var1, @Nullable Throwable var2, @Nullable Extras var3);

    public void onRelease(String var1, @Nullable Extras var2);

    public static class Extras {
        @Nullable
        public Map<String, Object> componentExtras;
        @Nullable
        public Map<String, Object> shortcutExtras;
        @Nullable
        public Map<String, Object> datasourceExtras;
        @Nullable
        public Map<String, Object> imageExtras;
        @Nullable
        public Object callerContext;
        @Nullable
        public Uri mainUri;
        public int viewportWidth = -1;
        public int viewportHeight = -1;
        @Nullable
        public Object scaleType;
        public float focusX = -1.0f;
        public float focusY = -1.0f;

        public static Extras of(@Nullable Map<String, Object> componentExtras) {
            Extras extras = new Extras();
            extras.componentExtras = componentExtras;
            return extras;
        }

        public Extras makeExtrasCopy() {
            Extras extras = new Extras();
            extras.componentExtras = Extras.copyMap(this.componentExtras);
            extras.shortcutExtras = Extras.copyMap(this.shortcutExtras);
            extras.datasourceExtras = Extras.copyMap(this.datasourceExtras);
            extras.imageExtras = Extras.copyMap(this.imageExtras);
            extras.callerContext = this.callerContext;
            extras.mainUri = this.mainUri;
            extras.viewportWidth = this.viewportWidth;
            extras.viewportHeight = this.viewportHeight;
            extras.scaleType = this.scaleType;
            extras.focusX = this.focusX;
            extras.focusY = this.focusY;
            return extras;
        }

        private static Map<String, Object> copyMap(@PropagatesNullable Map<String, Object> map) {
            if (map == null) {
                return null;
            }
            return new ConcurrentHashMap<String, Object>(map);
        }
    }
}

