/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.OOMSoftReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.Semaphore;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
public class SharedByteArray
implements MemoryTrimmable {
    @VisibleForTesting
    final int mMinByteArraySize;
    @VisibleForTesting
    final int mMaxByteArraySize;
    @VisibleForTesting
    final OOMSoftReference<byte[]> mByteArraySoftRef;
    @VisibleForTesting
    final Semaphore mSemaphore;
    private final ResourceReleaser<byte[]> mResourceReleaser;

    public SharedByteArray(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams params) {
        Preconditions.checkNotNull((Object)memoryTrimmableRegistry);
        Preconditions.checkArgument((Boolean)(params.minBucketSize > 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(params.maxBucketSize >= params.minBucketSize ? 1 : 0));
        this.mMaxByteArraySize = params.maxBucketSize;
        this.mMinByteArraySize = params.minBucketSize;
        this.mByteArraySoftRef = new OOMSoftReference();
        this.mSemaphore = new Semaphore(1);
        this.mResourceReleaser = new ResourceReleaser<byte[]>(){

            public void release(byte[] unused) {
                SharedByteArray.this.mSemaphore.release();
            }
        };
        memoryTrimmableRegistry.registerMemoryTrimmable((MemoryTrimmable)this);
    }

    public CloseableReference<byte[]> get(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Size must be greater than zero");
        Preconditions.checkArgument((size <= this.mMaxByteArraySize ? 1 : 0) != 0, (Object)"Requested size is too big");
        this.mSemaphore.acquireUninterruptibly();
        try {
            byte[] byteArray = this.getByteArray(size);
            return CloseableReference.of((Object)byteArray, this.mResourceReleaser);
        }
        catch (Throwable t) {
            this.mSemaphore.release();
            throw Throwables.propagate((Throwable)t);
        }
    }

    private byte[] getByteArray(int requestedSize) {
        int bucketedSize = this.getBucketedSize(requestedSize);
        byte[] byteArray = (byte[])this.mByteArraySoftRef.get();
        if (byteArray == null || byteArray.length < bucketedSize) {
            byteArray = this.allocateByteArray(bucketedSize);
        }
        return byteArray;
    }

    public void trim(MemoryTrimType trimType) {
        if (!this.mSemaphore.tryAcquire()) {
            return;
        }
        try {
            this.mByteArraySoftRef.clear();
        }
        finally {
            this.mSemaphore.release();
        }
    }

    @VisibleForTesting
    int getBucketedSize(int size) {
        size = Math.max(size, this.mMinByteArraySize);
        return Integer.highestOneBit(size - 1) * 2;
    }

    private synchronized byte[] allocateByteArray(int size) {
        this.mByteArraySoftRef.clear();
        byte[] byteArray = new byte[size];
        this.mByteArraySoftRef.set((Object)byteArray);
        return byteArray;
    }
}

