/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class PriorityStarvingThrottlingProducer<T>
implements Producer<T> {
    public static final String PRODUCER_NAME = "PriorityStarvingThrottlingProducer";
    private final Producer<T> mInputProducer;
    private final int mMaxSimultaneousRequests;
    @GuardedBy(value="this")
    private final Queue<Item<T>> mPendingRequests;
    private final Executor mExecutor;
    @GuardedBy(value="this")
    private int mNumCurrentRequests;

    public PriorityStarvingThrottlingProducer(int maxSimultaneousRequests, Executor executor, Producer<T> inputProducer) {
        this.mMaxSimultaneousRequests = maxSimultaneousRequests;
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mPendingRequests = new PriorityQueue(11, new PriorityComparator());
        this.mNumCurrentRequests = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<T> consumer, ProducerContext producerContext) {
        boolean delayRequest;
        long time = System.nanoTime();
        ProducerListener2 producerListener = producerContext.getProducerListener();
        producerListener.onProducerStart(producerContext, PRODUCER_NAME);
        PriorityStarvingThrottlingProducer priorityStarvingThrottlingProducer = this;
        synchronized (priorityStarvingThrottlingProducer) {
            if (this.mNumCurrentRequests >= this.mMaxSimultaneousRequests) {
                this.mPendingRequests.add(new Item<T>(consumer, producerContext, time));
                delayRequest = true;
            } else {
                ++this.mNumCurrentRequests;
                delayRequest = false;
            }
        }
        if (!delayRequest) {
            this.produceResultsInternal(new Item<T>(consumer, producerContext, time));
        }
    }

    private void produceResultsInternal(Item<T> item) {
        ProducerListener2 producerListener = item.producerContext.getProducerListener();
        producerListener.onProducerFinishWithSuccess(item.producerContext, PRODUCER_NAME, null);
        this.mInputProducer.produceResults(new ThrottlerConsumer(item.consumer), item.producerContext);
    }

    private class ThrottlerConsumer
    extends DelegatingConsumer<T, T> {
        private ThrottlerConsumer(Consumer<T> consumer) {
            super(consumer);
        }

        @Override
        protected void onNewResultImpl(@Nullable T newResult, int status) {
            this.getConsumer().onNewResult(newResult, status);
            if (ThrottlerConsumer.isLast(status)) {
                this.onRequestFinished();
            }
        }

        @Override
        protected void onFailureImpl(Throwable t) {
            this.getConsumer().onFailure(t);
            this.onRequestFinished();
        }

        @Override
        protected void onCancellationImpl() {
            this.getConsumer().onCancellation();
            this.onRequestFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRequestFinished() {
            Item nextRequest;
            PriorityStarvingThrottlingProducer priorityStarvingThrottlingProducer = PriorityStarvingThrottlingProducer.this;
            synchronized (priorityStarvingThrottlingProducer) {
                nextRequest = PriorityStarvingThrottlingProducer.this.mPendingRequests.poll();
                if (nextRequest == null) {
                    --PriorityStarvingThrottlingProducer.this.mNumCurrentRequests;
                }
            }
            if (nextRequest != null) {
                PriorityStarvingThrottlingProducer.this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        PriorityStarvingThrottlingProducer.this.produceResultsInternal(nextRequest);
                    }
                });
            }
        }
    }

    static class PriorityComparator<T>
    implements Comparator<Item<T>> {
        PriorityComparator() {
        }

        @Override
        public int compare(Item<T> o1, Item<T> o2) {
            Priority p2;
            Priority p1 = o1.producerContext.getPriority();
            if (p1 == (p2 = o2.producerContext.getPriority())) {
                return Double.compare(o1.time, o2.time);
            }
            if (p1.ordinal() > p2.ordinal()) {
                return -1;
            }
            return 1;
        }
    }

    static class Item<T> {
        final Consumer<T> consumer;
        final ProducerContext producerContext;
        final long time;

        Item(Consumer<T> consumer, ProducerContext producerContext, long time) {
            this.consumer = consumer;
            this.producerContext = producerContext;
            this.time = time;
        }
    }
}

