/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.callercontext.CallerContextVerifier;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Predicate;
import com.facebook.common.internal.Supplier;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.datasource.SimpleDataSource;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.core.ImagePipelineConfigInterface;
import com.facebook.imagepipeline.core.ImagePipelineExperiments;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.datasource.CloseableProducerToDataSourceAdapter;
import com.facebook.imagepipeline.datasource.ProducerToDataSourceAdapter;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.listener.ForwardingRequestListener;
import com.facebook.imagepipeline.listener.ForwardingRequestListener2;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.listener.RequestListener2;
import com.facebook.imagepipeline.producers.InternalRequestListener;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 n2\u00020\u0001:\u0001nB\u00b1\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\u0006\u00107\u001a\u000205J\u000e\u00108\u001a\u0002052\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002052\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010;\u001a\u0002052\b\u0010<\u001a\u0004\u0018\u00010=J\u000e\u0010>\u001a\u0002052\u0006\u00109\u001a\u00020:J&\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J.\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010.\u001a\u00020\u0006J.\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020DJV\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020D2\b\u0010.\u001a\u0004\u0018\u00010\u00062\b\u0010E\u001a\u0004\u0018\u00010F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0002\b\u0003\u0018\u00010HJJ\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FJ$\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110A0@2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J.\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110A0@2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0006J$\u0010J\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J\u0006\u0010K\u001a\u00020FJ\u001c\u0010L\u001a\u0004\u0018\u00010\u000e2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J\u0018\u0010M\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010A2\b\u0010N\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010O\u001a\u00020\u00062\b\u0010P\u001a\u0004\u0018\u00010\u0006J4\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@0\n2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010R\u001a\u0004\u0018\u00010DJ>\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@0\n2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010R\u001a\u0004\u0018\u00010D2\b\u0010.\u001a\u0004\u0018\u00010\u0006JH\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0A0@0\n2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010R\u001a\u0004\u0018\u00010D2\b\u0010.\u001a\u0004\u0018\u00010\u00062\b\u0010E\u001a\u0004\u0018\u00010FJ*\u0010S\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110A0@0\n2\u0006\u0010<\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J\u001a\u0010T\u001a\u00020\u00062\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010.\u001a\u0004\u0018\u00010\u0006J\u0010\u0010U\u001a\u00020\u000b2\b\u0010N\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010V\u001a\u000205J\u0010\u0010W\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010W\u001a\u00020\u000b2\b\u0010<\u001a\u0004\u0018\u00010=J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000b0@2\b\u00109\u001a\u0004\u0018\u00010:J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000b0@2\b\u0010<\u001a\u0004\u0018\u00010=J\u0010\u0010Y\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010:J\u001a\u0010Y\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010Z\u001a\u0004\u0018\u00010[J\u000e\u0010Y\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=J\u0010\u0010\\\u001a\u00020\u000b2\b\u00109\u001a\u0004\u0018\u00010:J\u0010\u0010\\\u001a\u00020\u000b2\b\u0010<\u001a\u0004\u0018\u00010=J\u0006\u0010]\u001a\u000205J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\u000e0_2\u0006\u00109\u001a\u00020:H\u0002J$\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u0007J.\u0010`\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0007J\"\u0010b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u0001J*\u0010b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010c\u001a\u00020dJ6\u0010b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010c\u001a\u00020d2\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0007J,\u0010b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0006J:\u0010e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010c\u001a\u00020d2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0006H\u0007J,\u0010e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0006J\u0006\u0010f\u001a\u000205J\\\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0@\"\u0004\b\u0000\u0010h2\u0012\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0j2\u0006\u0010<\u001a\u00020=2\u0006\u0010C\u001a\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u00062\b\u0010E\u001a\u0004\u0018\u00010FH\u0002Jp\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0@\"\u0004\b\u0000\u0010h2\u0012\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0j2\u0006\u0010<\u001a\u00020=2\u0006\u0010C\u001a\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u00062\b\u0010E\u001a\u0004\u0018\u00010F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0002\b\u0003\u0018\u00010HH\u0002Jf\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0@\"\u0004\b\u0000\u0010h2\u0012\u0010i\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0j2\u0006\u0010<\u001a\u00020=2\u0006\u0010C\u001a\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u00062\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0002\b\u0003\u0018\u00010HH\u0002J@\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hh0A0@\"\u0004\b\u0000\u0010h2\u0014\u0010i\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002Hh\u0018\u00010A0j2\u0006\u0010k\u001a\u00020l2\b\u0010.\u001a\u0004\u0018\u00010\u0006JL\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0@2\u000e\u0010i\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010a0j2\u0006\u0010<\u001a\u00020=2\u0006\u0010C\u001a\u00020D2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010c\u001a\u00020d2\b\u0010.\u001a\u0004\u0018\u00010\u0006H\u0002R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006o"}, d2={"Lcom/facebook/imagepipeline/core/ImagePipeline;", "", "producerSequenceFactory", "Lcom/facebook/imagepipeline/core/ProducerSequenceFactory;", "requestListeners", "", "Lcom/facebook/imagepipeline/listener/RequestListener;", "requestListener2s", "Lcom/facebook/imagepipeline/listener/RequestListener2;", "isPrefetchEnabledSupplier", "Lcom/facebook/common/internal/Supplier;", "", "bitmapMemoryCache", "Lcom/facebook/imagepipeline/cache/MemoryCache;", "Lcom/facebook/cache/common/CacheKey;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "encodedMemoryCache", "Lcom/facebook/common/memory/PooledByteBuffer;", "mainBufferedDiskCache", "Lcom/facebook/imagepipeline/cache/BufferedDiskCache;", "smallImageBufferedDiskCache", "cacheKeyFactory", "Lcom/facebook/imagepipeline/cache/CacheKeyFactory;", "threadHandoffProducerQueue", "Lcom/facebook/imagepipeline/producers/ThreadHandoffProducerQueue;", "suppressBitmapPrefetchingSupplier", "lazyDataSource", "callerContextVerifier", "Lcom/facebook/callercontext/CallerContextVerifier;", "config", "Lcom/facebook/imagepipeline/core/ImagePipelineConfigInterface;", "(Lcom/facebook/imagepipeline/core/ProducerSequenceFactory;Ljava/util/Set;Ljava/util/Set;Lcom/facebook/common/internal/Supplier;Lcom/facebook/imagepipeline/cache/MemoryCache;Lcom/facebook/imagepipeline/cache/MemoryCache;Lcom/facebook/imagepipeline/cache/BufferedDiskCache;Lcom/facebook/imagepipeline/cache/BufferedDiskCache;Lcom/facebook/imagepipeline/cache/CacheKeyFactory;Lcom/facebook/imagepipeline/producers/ThreadHandoffProducerQueue;Lcom/facebook/common/internal/Supplier;Lcom/facebook/common/internal/Supplier;Lcom/facebook/callercontext/CallerContextVerifier;Lcom/facebook/imagepipeline/core/ImagePipelineConfigInterface;)V", "getBitmapMemoryCache", "()Lcom/facebook/imagepipeline/cache/MemoryCache;", "getCacheKeyFactory", "()Lcom/facebook/imagepipeline/cache/CacheKeyFactory;", "getConfig", "()Lcom/facebook/imagepipeline/core/ImagePipelineConfigInterface;", "idCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "isLazyDataSource", "()Lcom/facebook/common/internal/Supplier;", "isPaused", "()Z", "getProducerSequenceFactory", "()Lcom/facebook/imagepipeline/core/ProducerSequenceFactory;", "requestListener", "requestListener2", "usedDiskCacheSize", "", "getUsedDiskCacheSize", "()J", "clearCaches", "", "clearDiskCaches", "clearMemoryCaches", "evictFromCache", "uri", "Landroid/net/Uri;", "evictFromDiskCache", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "evictFromMemoryCache", "fetchDecodedImage", "Lcom/facebook/datasource/DataSource;", "Lcom/facebook/common/references/CloseableReference;", "callerContext", "lowestPermittedRequestLevelOnSubmit", "Lcom/facebook/imagepipeline/request/ImageRequest$RequestLevel;", "uiComponentId", "", "extras", "", "fetchEncodedImage", "fetchImageFromBitmapCache", "generateUniqueFutureId", "getCacheKey", "getCachedImage", "cacheKey", "getCombinedRequestListener", "listener", "getDataSourceSupplier", "requestLevel", "getEncodedImageDataSourceSupplier", "getRequestListenerForRequest", "hasCachedImage", "init", "isInBitmapMemoryCache", "isInDiskCache", "isInDiskCacheSync", "cacheChoice", "Lcom/facebook/imagepipeline/request/ImageRequest$CacheChoice;", "isInEncodedMemoryCache", "pause", "predicateForUri", "Lcom/facebook/common/internal/Predicate;", "prefetchToBitmapCache", "Ljava/lang/Void;", "prefetchToDiskCache", "priority", "Lcom/facebook/imagepipeline/common/Priority;", "prefetchToEncodedCache", "resume", "submitFetchRequest", "T", "producerSequence", "Lcom/facebook/imagepipeline/producers/Producer;", "settableProducerContext", "Lcom/facebook/imagepipeline/producers/SettableProducerContext;", "submitPrefetchRequest", "Companion", "imagepipeline_release"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nImagePipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePipeline.kt\ncom/facebook/imagepipeline/core/ImagePipeline\n+ 2 FrescoSystrace.kt\ncom/facebook/imagepipeline/systrace/FrescoSystrace\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1046:1\n40#2,9:1047\n40#2,9:1056\n40#2,9:1065\n40#2,9:1074\n40#2,9:1083\n40#2,9:1092\n1#3:1101\n*S KotlinDebug\n*F\n+ 1 ImagePipeline.kt\ncom/facebook/imagepipeline/core/ImagePipeline\n*L\n418#1:1047,9\n550#1:1056,9\n803#1:1065,9\n868#1:1074,9\n906#1:1083,9\n940#1:1092,9\n*E\n"})
public final class ImagePipeline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProducerSequenceFactory producerSequenceFactory;
    @NotNull
    private final Supplier<Boolean> isPrefetchEnabledSupplier;
    @NotNull
    private final RequestListener requestListener;
    @NotNull
    private final RequestListener2 requestListener2;
    @NotNull
    private final MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache;
    @NotNull
    private final MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache;
    @NotNull
    private final BufferedDiskCache mainBufferedDiskCache;
    @NotNull
    private final BufferedDiskCache smallImageBufferedDiskCache;
    @NotNull
    private final CacheKeyFactory cacheKeyFactory;
    @NotNull
    private final ThreadHandoffProducerQueue threadHandoffProducerQueue;
    @NotNull
    private final Supplier<Boolean> suppressBitmapPrefetchingSupplier;
    @NotNull
    private final AtomicLong idCounter;
    @NotNull
    private final Supplier<Boolean> isLazyDataSource;
    @Nullable
    private final CallerContextVerifier callerContextVerifier;
    @NotNull
    private final ImagePipelineConfigInterface config;
    @NotNull
    private static final CancellationException PREFETCH_EXCEPTION = new CancellationException("Prefetching is not enabled");
    @NotNull
    private static final CancellationException NULL_IMAGEREQUEST_EXCEPTION = new CancellationException("ImageRequest is null");

    public ImagePipeline(@NotNull ProducerSequenceFactory producerSequenceFactory, @NotNull Set<? extends RequestListener> requestListeners, @NotNull Set<? extends RequestListener2> requestListener2s, @NotNull Supplier<Boolean> isPrefetchEnabledSupplier, @NotNull MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache, @NotNull MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache, @NotNull BufferedDiskCache mainBufferedDiskCache, @NotNull BufferedDiskCache smallImageBufferedDiskCache, @NotNull CacheKeyFactory cacheKeyFactory, @NotNull ThreadHandoffProducerQueue threadHandoffProducerQueue, @NotNull Supplier<Boolean> suppressBitmapPrefetchingSupplier, @NotNull Supplier<Boolean> lazyDataSource, @Nullable CallerContextVerifier callerContextVerifier, @NotNull ImagePipelineConfigInterface config) {
        Intrinsics.checkNotNullParameter((Object)producerSequenceFactory, (String)"producerSequenceFactory");
        Intrinsics.checkNotNullParameter(requestListeners, (String)"requestListeners");
        Intrinsics.checkNotNullParameter(requestListener2s, (String)"requestListener2s");
        Intrinsics.checkNotNullParameter(isPrefetchEnabledSupplier, (String)"isPrefetchEnabledSupplier");
        Intrinsics.checkNotNullParameter(bitmapMemoryCache, (String)"bitmapMemoryCache");
        Intrinsics.checkNotNullParameter(encodedMemoryCache, (String)"encodedMemoryCache");
        Intrinsics.checkNotNullParameter((Object)mainBufferedDiskCache, (String)"mainBufferedDiskCache");
        Intrinsics.checkNotNullParameter((Object)smallImageBufferedDiskCache, (String)"smallImageBufferedDiskCache");
        Intrinsics.checkNotNullParameter((Object)cacheKeyFactory, (String)"cacheKeyFactory");
        Intrinsics.checkNotNullParameter((Object)threadHandoffProducerQueue, (String)"threadHandoffProducerQueue");
        Intrinsics.checkNotNullParameter(suppressBitmapPrefetchingSupplier, (String)"suppressBitmapPrefetchingSupplier");
        Intrinsics.checkNotNullParameter(lazyDataSource, (String)"lazyDataSource");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.producerSequenceFactory = producerSequenceFactory;
        this.isPrefetchEnabledSupplier = isPrefetchEnabledSupplier;
        this.requestListener = new ForwardingRequestListener(requestListeners);
        this.requestListener2 = new ForwardingRequestListener2(requestListener2s);
        this.idCounter = new AtomicLong();
        this.bitmapMemoryCache = bitmapMemoryCache;
        this.encodedMemoryCache = encodedMemoryCache;
        this.mainBufferedDiskCache = mainBufferedDiskCache;
        this.smallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.cacheKeyFactory = cacheKeyFactory;
        this.threadHandoffProducerQueue = threadHandoffProducerQueue;
        this.suppressBitmapPrefetchingSupplier = suppressBitmapPrefetchingSupplier;
        this.isLazyDataSource = lazyDataSource;
        this.callerContextVerifier = callerContextVerifier;
        this.config = config;
    }

    @NotNull
    public final ProducerSequenceFactory getProducerSequenceFactory() {
        return this.producerSequenceFactory;
    }

    @NotNull
    public final MemoryCache<CacheKey, CloseableImage> getBitmapMemoryCache() {
        return this.bitmapMemoryCache;
    }

    @NotNull
    public final CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory;
    }

    @NotNull
    public final Supplier<Boolean> isLazyDataSource() {
        return this.isLazyDataSource;
    }

    @NotNull
    public final ImagePipelineConfigInterface getConfig() {
        return this.config;
    }

    @NotNull
    public final String generateUniqueFutureId() {
        return String.valueOf(this.idCounter.getAndIncrement());
    }

    @NotNull
    public final Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(@NotNull ImageRequest imageRequest, @Nullable Object callerContext, @Nullable ImageRequest.RequestLevel requestLevel) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return (Supplier)new Supplier<DataSource<CloseableReference<CloseableImage>>>(this, imageRequest, callerContext, requestLevel){
            final /* synthetic */ ImagePipeline this$0;
            final /* synthetic */ ImageRequest $imageRequest;
            final /* synthetic */ Object $callerContext;
            final /* synthetic */ ImageRequest.RequestLevel $requestLevel;
            {
                this.this$0 = $receiver;
                this.$imageRequest = $imageRequest;
                this.$callerContext = $callerContext;
                this.$requestLevel = $requestLevel;
            }

            @NotNull
            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.fetchDecodedImage$default(this.this$0, this.$imageRequest, this.$callerContext, this.$requestLevel, null, null, 24, null);
            }

            @NotNull
            public String toString() {
                String string = Objects.toStringHelper((Object)this).add("uri", (Object)this.$imageRequest.getSourceUri()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this).add\u2026est.sourceUri).toString()");
                return string;
            }
        };
    }

    @NotNull
    public final Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(@NotNull ImageRequest imageRequest, @Nullable Object callerContext, @Nullable ImageRequest.RequestLevel requestLevel, @Nullable RequestListener requestListener) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return (Supplier)new Supplier<DataSource<CloseableReference<CloseableImage>>>(this, imageRequest, callerContext, requestLevel, requestListener){
            final /* synthetic */ ImagePipeline this$0;
            final /* synthetic */ ImageRequest $imageRequest;
            final /* synthetic */ Object $callerContext;
            final /* synthetic */ ImageRequest.RequestLevel $requestLevel;
            final /* synthetic */ RequestListener $requestListener;
            {
                this.this$0 = $receiver;
                this.$imageRequest = $imageRequest;
                this.$callerContext = $callerContext;
                this.$requestLevel = $requestLevel;
                this.$requestListener = $requestListener;
            }

            @NotNull
            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.fetchDecodedImage$default(this.this$0, this.$imageRequest, this.$callerContext, this.$requestLevel, this.$requestListener, null, 16, null);
            }

            @NotNull
            public String toString() {
                String string = Objects.toStringHelper((Object)this).add("uri", (Object)this.$imageRequest.getSourceUri()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this).add\u2026est.sourceUri).toString()");
                return string;
            }
        };
    }

    @NotNull
    public final Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(@NotNull ImageRequest imageRequest, @Nullable Object callerContext, @Nullable ImageRequest.RequestLevel requestLevel, @Nullable RequestListener requestListener, @Nullable String uiComponentId) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return (Supplier)new Supplier<DataSource<CloseableReference<CloseableImage>>>(this, imageRequest, callerContext, requestLevel, requestListener, uiComponentId){
            final /* synthetic */ ImagePipeline this$0;
            final /* synthetic */ ImageRequest $imageRequest;
            final /* synthetic */ Object $callerContext;
            final /* synthetic */ ImageRequest.RequestLevel $requestLevel;
            final /* synthetic */ RequestListener $requestListener;
            final /* synthetic */ String $uiComponentId;
            {
                this.this$0 = $receiver;
                this.$imageRequest = $imageRequest;
                this.$callerContext = $callerContext;
                this.$requestLevel = $requestLevel;
                this.$requestListener = $requestListener;
                this.$uiComponentId = $uiComponentId;
            }

            @NotNull
            public DataSource<CloseableReference<CloseableImage>> get() {
                return this.this$0.fetchDecodedImage(this.$imageRequest, this.$callerContext, this.$requestLevel, this.$requestListener, this.$uiComponentId);
            }

            @NotNull
            public String toString() {
                String string = Objects.toStringHelper((Object)this).add("uri", (Object)this.$imageRequest.getSourceUri()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this).add\u2026est.sourceUri).toString()");
                return string;
            }
        };
    }

    @NotNull
    public final Supplier<DataSource<CloseableReference<PooledByteBuffer>>> getEncodedImageDataSourceSupplier(@NotNull ImageRequest imageRequest, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return (Supplier)new Supplier<DataSource<CloseableReference<PooledByteBuffer>>>(this, imageRequest, callerContext){
            final /* synthetic */ ImagePipeline this$0;
            final /* synthetic */ ImageRequest $imageRequest;
            final /* synthetic */ Object $callerContext;
            {
                this.this$0 = $receiver;
                this.$imageRequest = $imageRequest;
                this.$callerContext = $callerContext;
            }

            @NotNull
            public DataSource<CloseableReference<PooledByteBuffer>> get() {
                return this.this$0.fetchEncodedImage(this.$imageRequest, this.$callerContext);
            }

            @NotNull
            public String toString() {
                String string = Objects.toStringHelper((Object)this).add("uri", (Object)this.$imageRequest.getSourceUri()).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this).add\u2026est.sourceUri).toString()");
                return string;
            }
        };
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchImageFromBitmapCache(@NotNull ImageRequest imageRequest, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE);
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @Nullable ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, @Nullable RequestListener requestListener, @Nullable String uiComponentId) {
        DataSource dataSource;
        if (imageRequest == null) {
            DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)new NullPointerException());
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"immediateFailedDataSource(NullPointerException())");
            return dataSource2;
        }
        try {
            Producer producerSequence = this.producerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            ImageRequest.RequestLevel requestLevel = lowestPermittedRequestLevelOnSubmit;
            if (requestLevel == null) {
                requestLevel = ImageRequest.RequestLevel.FULL_FETCH;
            }
            dataSource = this.submitFetchRequest(producerSequence, imageRequest, requestLevel, callerContext, requestListener, uiComponentId);
        }
        catch (Exception exception) {
            DataSource dataSource3 = DataSources.immediateFailedDataSource((Throwable)exception);
            Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n      DataSources.imme\u2026taSource(exception)\n    }");
            dataSource = dataSource3;
        }
        return dataSource;
    }

    public static /* synthetic */ DataSource fetchDecodedImage$default(ImagePipeline imagePipeline, ImageRequest imageRequest, Object object, ImageRequest.RequestLevel requestLevel, RequestListener requestListener, String string, int n, Object object2) {
        if ((n & 4) != 0) {
            requestLevel = null;
        }
        if ((n & 8) != 0) {
            requestListener = null;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        return imagePipeline.fetchDecodedImage(imageRequest, object, requestLevel, requestListener, string);
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        return ImagePipeline.fetchDecodedImage$default(this, imageRequest, callerContext, null, null, null, 24, null);
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull RequestListener requestListener) {
        Intrinsics.checkNotNullParameter((Object)requestListener, (String)"requestListener");
        return ImagePipeline.fetchDecodedImage$default(this, imageRequest, callerContext, null, requestListener, null, 16, null);
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit) {
        Intrinsics.checkNotNullParameter((Object)((Object)lowestPermittedRequestLevelOnSubmit), (String)"lowestPermittedRequestLevelOnSubmit");
        return ImagePipeline.fetchDecodedImage$default(this, imageRequest, callerContext, lowestPermittedRequestLevelOnSubmit, null, null, 16, null);
    }

    @NotNull
    public final DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, @Nullable RequestListener requestListener, @Nullable String uiComponentId, @Nullable Map<String, ?> extras) {
        DataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)((Object)lowestPermittedRequestLevelOnSubmit), (String)"lowestPermittedRequestLevelOnSubmit");
        if (imageRequest == null) {
            DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)new NullPointerException());
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"immediateFailedDataSource(NullPointerException())");
            return dataSource2;
        }
        try {
            Producer producerSequence = this.producerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            dataSource = this.submitFetchRequest(producerSequence, imageRequest, lowestPermittedRequestLevelOnSubmit, callerContext, requestListener, uiComponentId, extras);
        }
        catch (Exception exception) {
            DataSource dataSource3 = DataSources.immediateFailedDataSource((Throwable)exception);
            Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n      DataSources.imme\u2026taSource(exception)\n    }");
            dataSource = dataSource3;
        }
        return dataSource;
    }

    @NotNull
    public final DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(@NotNull ImageRequest imageRequest, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return this.fetchEncodedImage(imageRequest, callerContext, null);
    }

    @NotNull
    public final DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(@NotNull ImageRequest imageRequest, @Nullable Object callerContext, @Nullable RequestListener requestListener) {
        DataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        ImageRequest imageRequest2 = imageRequest;
        if (imageRequest2.getSourceUri() == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        try {
            Producer producerSequence = this.producerSequenceFactory.getEncodedImageProducerSequence(imageRequest2);
            if (imageRequest2.getResizeOptions() != null) {
                ImageRequest imageRequest3 = ImageRequestBuilder.fromRequest(imageRequest2).setResizeOptions(null).build();
                Intrinsics.checkNotNullExpressionValue((Object)imageRequest3, (String)"fromRequest(imageRequest\u2026sizeOptions(null).build()");
                imageRequest2 = imageRequest3;
            }
            dataSource = this.submitFetchRequest(producerSequence, imageRequest2, ImageRequest.RequestLevel.FULL_FETCH, callerContext, requestListener, null, null);
        }
        catch (Exception exception) {
            DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)exception);
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"{\n      DataSources.imme\u2026taSource(exception)\n    }");
            dataSource = dataSource2;
        }
        return dataSource;
    }

    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToBitmapCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        return this.prefetchToBitmapCache(imageRequest, callerContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToBitmapCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @Nullable RequestListener requestListener) {
        DataSource dataSource;
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#prefetchToBitmapCache";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            Object shouldDecodePrefetches;
            boolean bl = false;
            if (!((Boolean)this.isPrefetchEnabledSupplier.get()).booleanValue()) {
                DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"immediateFailedDataSource(PREFETCH_EXCEPTION)");
                return dataSource2;
            }
            try {
                boolean bl2;
                if (this.config.getExperiments().getPrefetchShortcutEnabled() && this.isInBitmapMemoryCache(imageRequest)) {
                    DataSource dataSource3 = DataSources.immediateSuccessfulDataSource();
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"immediateSuccessfulDataSource()");
                    return dataSource3;
                }
                if (imageRequest == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                shouldDecodePrefetches = imageRequest.shouldDecodePrefetches();
                if (shouldDecodePrefetches != null) {
                    bl2 = !((Boolean)shouldDecodePrefetches).booleanValue();
                } else {
                    Object object = this.suppressBitmapPrefetchingSupplier.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"suppressBitmapPrefetchin\u2026                   .get()");
                    bl2 = (Boolean)object;
                }
                boolean skipBitmapCache = bl2;
                Producer<Void> producerSequence = skipBitmapCache ? this.producerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest) : this.producerSequenceFactory.getDecodedImagePrefetchProducerSequence(imageRequest);
                shouldDecodePrefetches = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, Priority.MEDIUM, requestListener);
            }
            catch (Exception exception) {
                DataSource dataSource4 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource4, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                shouldDecodePrefetches = dataSource4;
            }
            dataSource = shouldDecodePrefetches;
        } else {
            block20: {
                block19: {
                    FrescoSystrace.beginSection((String)name$iv);
                    boolean bl = false;
                    if (((Boolean)this.isPrefetchEnabledSupplier.get()).booleanValue()) break block19;
                    DataSource dataSource5 = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource5, (String)"immediateFailedDataSource(PREFETCH_EXCEPTION)");
                    DataSource dataSource6 = dataSource5;
                    FrescoSystrace.endSection();
                    return dataSource6;
                }
                if (!this.config.getExperiments().getPrefetchShortcutEnabled() || !this.isInBitmapMemoryCache(imageRequest)) break block20;
                DataSource dataSource7 = DataSources.immediateSuccessfulDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dataSource7, (String)"immediateSuccessfulDataSource()");
                DataSource dataSource8 = dataSource7;
                FrescoSystrace.endSection();
                return dataSource8;
            }
            try {
                DataSource<Void> dataSource9;
                try {
                    boolean bl;
                    if (imageRequest == null) {
                        String shouldDecodePrefetches = "Required value was null.";
                        throw new IllegalStateException(shouldDecodePrefetches.toString());
                    }
                    Boolean shouldDecodePrefetches = imageRequest.shouldDecodePrefetches();
                    if (shouldDecodePrefetches != null) {
                        bl = !shouldDecodePrefetches.booleanValue();
                    } else {
                        Object object = this.suppressBitmapPrefetchingSupplier.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"suppressBitmapPrefetchin\u2026                   .get()");
                        bl = (Boolean)object;
                    }
                    boolean skipBitmapCache = bl;
                    Producer<Void> producerSequence = skipBitmapCache ? this.producerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest) : this.producerSequenceFactory.getDecodedImagePrefetchProducerSequence(imageRequest);
                    dataSource9 = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, Priority.MEDIUM, requestListener);
                }
                catch (Exception exception) {
                    DataSource<Void> dataSource10 = DataSources.immediateFailedDataSource((Throwable)exception);
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource10, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                    dataSource9 = dataSource10;
                }
                DataSource<Void> dataSource11 = dataSource9;
                dataSource = dataSource11;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return dataSource;
    }

    @NotNull
    public final DataSource<Void> prefetchToDiskCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @Nullable RequestListener requestListener) {
        return this.prefetchToDiskCache(imageRequest, callerContext, Priority.MEDIUM, requestListener);
    }

    @NotNull
    public final DataSource<Void> prefetchToDiskCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        return this.prefetchToDiskCache(imageRequest, callerContext, Priority.MEDIUM, null);
    }

    @NotNull
    public final DataSource<Void> prefetchToDiskCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        return this.prefetchToDiskCache(imageRequest, callerContext, priority, null);
    }

    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToDiskCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull Priority priority, @Nullable RequestListener requestListener) {
        DataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        if (!((Boolean)this.isPrefetchEnabledSupplier.get()).booleanValue()) {
            DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"immediateFailedDataSource(PREFETCH_EXCEPTION)");
            return dataSource2;
        }
        if (imageRequest == null) {
            DataSource dataSource3 = DataSources.immediateFailedDataSource((Throwable)new NullPointerException("imageRequest is null"));
            dataSource = dataSource3;
            Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n      DataSources.imme\u2026eRequest is null\"))\n    }");
        } else {
            DataSource<Void> dataSource4;
            try {
                Producer<Void> producerSequence = this.producerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
                dataSource4 = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority, requestListener);
            }
            catch (Exception exception) {
                DataSource<Void> dataSource5 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource5, (String)"{\n        DataSources.im\u2026Source(exception)\n      }");
                dataSource4 = dataSource5;
            }
            dataSource = dataSource4;
        }
        return dataSource;
    }

    @NotNull
    public final DataSource<Void> prefetchToEncodedCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @Nullable RequestListener requestListener) {
        return this.prefetchToEncodedCache(imageRequest, callerContext, Priority.MEDIUM, requestListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToEncodedCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull Priority priority, @Nullable RequestListener requestListener) {
        DataSource dataSource;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#prefetchToEncodedCache";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            DataSource<Void> producerSequence;
            boolean bl = false;
            if (!((Boolean)this.isPrefetchEnabledSupplier.get()).booleanValue()) {
                DataSource dataSource2 = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"immediateFailedDataSource(PREFETCH_EXCEPTION)");
                return dataSource2;
            }
            if (imageRequest == null) {
                DataSource dataSource3 = DataSources.immediateFailedDataSource((Throwable)NULL_IMAGEREQUEST_EXCEPTION);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"immediateFailedDataSourc\u2026L_IMAGEREQUEST_EXCEPTION)");
                return dataSource3;
            }
            try {
                if (this.config.getExperiments().getPrefetchShortcutEnabled() && this.isInEncodedMemoryCache(imageRequest)) {
                    DataSource dataSource4 = DataSources.immediateSuccessfulDataSource();
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource4, (String)"immediateSuccessfulDataSource()");
                    return dataSource4;
                }
                producerSequence = this.producerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
                producerSequence = this.submitPrefetchRequest((Producer<Void>)producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority, requestListener);
            }
            catch (Exception exception) {
                DataSource dataSource5 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource5, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                producerSequence = dataSource5;
            }
            dataSource = producerSequence;
        } else {
            block17: {
                block16: {
                    block15: {
                        FrescoSystrace.beginSection((String)name$iv);
                        boolean bl = false;
                        if (((Boolean)this.isPrefetchEnabledSupplier.get()).booleanValue()) break block15;
                        DataSource dataSource6 = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                        Intrinsics.checkNotNullExpressionValue((Object)dataSource6, (String)"immediateFailedDataSource(PREFETCH_EXCEPTION)");
                        DataSource dataSource7 = dataSource6;
                        FrescoSystrace.endSection();
                        return dataSource7;
                    }
                    if (imageRequest != null) break block16;
                    DataSource dataSource8 = DataSources.immediateFailedDataSource((Throwable)NULL_IMAGEREQUEST_EXCEPTION);
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource8, (String)"immediateFailedDataSourc\u2026L_IMAGEREQUEST_EXCEPTION)");
                    DataSource dataSource9 = dataSource8;
                    FrescoSystrace.endSection();
                    return dataSource9;
                }
                if (!this.config.getExperiments().getPrefetchShortcutEnabled() || !this.isInEncodedMemoryCache(imageRequest)) break block17;
                DataSource dataSource10 = DataSources.immediateSuccessfulDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dataSource10, (String)"immediateSuccessfulDataSource()");
                DataSource dataSource11 = dataSource10;
                FrescoSystrace.endSection();
                return dataSource11;
            }
            try {
                DataSource<Void> dataSource12;
                try {
                    Producer<Void> producerSequence = this.producerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
                    dataSource12 = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority, requestListener);
                }
                catch (Exception exception) {
                    DataSource<Void> dataSource13 = DataSources.immediateFailedDataSource((Throwable)exception);
                    Intrinsics.checkNotNullExpressionValue((Object)dataSource13, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                    dataSource12 = dataSource13;
                }
                DataSource<Void> dataSource14 = dataSource12;
                dataSource = dataSource14;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return dataSource;
    }

    public static /* synthetic */ DataSource prefetchToEncodedCache$default(ImagePipeline imagePipeline, ImageRequest imageRequest, Object object, Priority priority, RequestListener requestListener, int n, Object object2) {
        if ((n & 4) != 0) {
            priority = Priority.MEDIUM;
        }
        if ((n & 8) != 0) {
            requestListener = null;
        }
        return imagePipeline.prefetchToEncodedCache(imageRequest, object, priority, requestListener);
    }

    public final void evictFromMemoryCache(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Predicate<CacheKey> predicate = this.predicateForUri(uri);
        this.bitmapMemoryCache.removeAll(predicate);
        this.encodedMemoryCache.removeAll(predicate);
    }

    public final void evictFromDiskCache(@Nullable Uri uri) {
        ImageRequest imageRequest = ImageRequest.fromUri(uri);
        if (imageRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.evictFromDiskCache(imageRequest);
    }

    public final void evictFromDiskCache(@Nullable ImageRequest imageRequest) {
        if (imageRequest == null) {
            return;
        }
        CacheKey cacheKey = this.cacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
        this.mainBufferedDiskCache.remove(cacheKey);
        this.smallImageBufferedDiskCache.remove(cacheKey);
    }

    public final void evictFromCache(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.evictFromMemoryCache(uri);
        this.evictFromDiskCache(uri);
    }

    public final void clearMemoryCaches() {
        Predicate allPredicate = ImagePipeline::clearMemoryCaches$lambda$2;
        this.bitmapMemoryCache.removeAll(allPredicate);
        this.encodedMemoryCache.removeAll(allPredicate);
    }

    public final void clearDiskCaches() {
        this.mainBufferedDiskCache.clearAll();
        this.smallImageBufferedDiskCache.clearAll();
    }

    public final long getUsedDiskCacheSize() {
        return this.mainBufferedDiskCache.getSize() + this.smallImageBufferedDiskCache.getSize();
    }

    public final void clearCaches() {
        this.clearMemoryCaches();
        this.clearDiskCaches();
    }

    public final boolean isInBitmapMemoryCache(@Nullable Uri uri) {
        if (uri == null) {
            return false;
        }
        Predicate<CacheKey> bitmapCachePredicate = this.predicateForUri(uri);
        return this.bitmapMemoryCache.contains(bitmapCachePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInBitmapMemoryCache(@Nullable ImageRequest imageRequest) {
        boolean bl;
        if (imageRequest == null) {
            return false;
        }
        CacheKey cacheKey = this.cacheKeyFactory.getBitmapCacheKey(imageRequest, null);
        Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
        CloseableReference ref = this.bitmapMemoryCache.get((Object)cacheKey);
        try {
            bl = CloseableReference.isValid((CloseableReference)ref);
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
        }
        return bl;
    }

    public final boolean isInEncodedMemoryCache(@Nullable Uri uri) {
        if (uri == null) {
            return false;
        }
        Predicate<CacheKey> encodedCachePredicate = this.predicateForUri(uri);
        return this.encodedMemoryCache.contains(encodedCachePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInEncodedMemoryCache(@Nullable ImageRequest imageRequest) {
        boolean bl;
        if (imageRequest == null) {
            return false;
        }
        CacheKey cacheKey = this.cacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
        CloseableReference ref = this.encodedMemoryCache.get((Object)cacheKey);
        try {
            bl = CloseableReference.isValid((CloseableReference)ref);
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
        }
        return bl;
    }

    public final boolean isInDiskCacheSync(@Nullable Uri uri) {
        return this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.SMALL) || this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.DEFAULT);
    }

    public final boolean isInDiskCacheSync(@Nullable Uri uri, @Nullable ImageRequest.CacheChoice cacheChoice) {
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource(uri).setCacheChoice(cacheChoice).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageRequest, (String)"imageRequest");
        return this.isInDiskCacheSync(imageRequest);
    }

    public final boolean isInDiskCacheSync(@NotNull ImageRequest imageRequest) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        CacheKey cacheKey = this.cacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        ImageRequest.CacheChoice cacheChoice = imageRequest.getCacheChoice();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cacheChoice), (String)"imageRequest.cacheChoice");
        ImageRequest.CacheChoice cacheChoice2 = cacheChoice;
        switch (WhenMappings.$EnumSwitchMapping$0[cacheChoice2.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
                bl = this.mainBufferedDiskCache.diskCheckSync(cacheKey);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
                bl = this.smallImageBufferedDiskCache.diskCheckSync(cacheKey);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final DataSource<Boolean> isInDiskCache(@Nullable Uri uri) {
        ImageRequest imageRequest = ImageRequest.fromUri(uri);
        if (imageRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return this.isInDiskCache(imageRequest);
    }

    @NotNull
    public final DataSource<Boolean> isInDiskCache(@Nullable ImageRequest imageRequest) {
        CacheKey cacheKey = this.cacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        SimpleDataSource dataSource = SimpleDataSource.create();
        Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"cacheKey");
        this.mainBufferedDiskCache.contains(cacheKey).continueWithTask(arg_0 -> ImagePipeline.isInDiskCache$lambda$3(this, cacheKey, arg_0)).continueWith(arg_0 -> ImagePipeline.isInDiskCache$lambda$4(dataSource, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataSource, (String)"dataSource");
        return (DataSource)dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CacheKey getCacheKey(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#getCacheKey";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            CacheKey cacheKey = null;
            if (imageRequest != null) {
                cacheKey = imageRequest.getPostprocessor() != null ? this.cacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest, callerContext) : this.cacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
            }
            return cacheKey;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            boolean bl = false;
            CacheKey cacheKey = null;
            if (imageRequest != null) {
                cacheKey = imageRequest.getPostprocessor() != null ? this.cacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest, callerContext) : this.cacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
            }
            CacheKey cacheKey2 = cacheKey;
            return cacheKey2;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    @Nullable
    public final CloseableReference<CloseableImage> getCachedImage(@Nullable CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        CloseableReference closeableImage = this.bitmapMemoryCache.get((Object)cacheKey);
        if (closeableImage != null && !((CloseableImage)closeableImage.get()).getQualityInfo().isOfFullQuality()) {
            closeableImage.close();
            return null;
        }
        return closeableImage;
    }

    public final boolean hasCachedImage(@Nullable CacheKey cacheKey) {
        return cacheKey == null ? false : this.bitmapMemoryCache.contains((Object)cacheKey);
    }

    private final <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, RequestListener requestListener, String uiComponentId) {
        return this.submitFetchRequest(producerSequence, imageRequest, lowestPermittedRequestLevelOnSubmit, callerContext, requestListener, uiComponentId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, RequestListener requestListener, String uiComponentId, Map<String, ?> extras) {
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#submitFetchRequest";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.requestListener2);
            CallerContextVerifier callerContextVerifier = this.callerContextVerifier;
            if (callerContextVerifier != null) {
                callerContextVerifier.verifyCallerContext(callerContext, false);
            }
            try {
                ImageRequest.RequestLevel requestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)requestLevel), (String)"getMax(\n                \u2026ttedRequestLevelOnSubmit)");
                ImageRequest.RequestLevel lowestPermittedRequestLevel = requestLevel;
                SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), uiComponentId, requestListener2, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority(), this.config);
                settableProducerContext.putExtras(extras);
                dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource, (String)"{\n          val lowestPe\u2026questListener2)\n        }");
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource2 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource2;
            }
            return dataSource;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.requestListener2);
            CallerContextVerifier callerContextVerifier = this.callerContextVerifier;
            if (callerContextVerifier != null) {
                callerContextVerifier.verifyCallerContext(callerContext, false);
            }
            try {
                ImageRequest.RequestLevel requestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)requestLevel), (String)"getMax(\n                \u2026ttedRequestLevelOnSubmit)");
                ImageRequest.RequestLevel lowestPermittedRequestLevel = requestLevel;
                SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), uiComponentId, requestListener2, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority(), this.config);
                settableProducerContext.putExtras(extras);
                dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource, (String)"{\n          val lowestPe\u2026questListener2)\n        }");
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource3 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource3;
            }
            DataSource<CloseableReference<T>> dataSource4 = dataSource;
            return dataSource4;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, RequestListener requestListener, Map<String, ?> extras) {
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#submitFetchRequest";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.requestListener2);
            CallerContextVerifier callerContextVerifier = this.callerContextVerifier;
            if (callerContextVerifier != null) {
                callerContextVerifier.verifyCallerContext(callerContext, false);
            }
            try {
                ImageRequest.RequestLevel requestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)requestLevel), (String)"getMax(\n                \u2026ttedRequestLevelOnSubmit)");
                ImageRequest.RequestLevel lowestPermittedRequestLevel = requestLevel;
                SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), null, requestListener2, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority(), this.config);
                dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource, (String)"{\n          val lowestPe\u2026questListener2)\n        }");
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource2 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource2;
            }
            return dataSource;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.requestListener2);
            CallerContextVerifier callerContextVerifier = this.callerContextVerifier;
            if (callerContextVerifier != null) {
                callerContextVerifier.verifyCallerContext(callerContext, false);
            }
            try {
                ImageRequest.RequestLevel requestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)requestLevel), (String)"getMax(\n                \u2026ttedRequestLevelOnSubmit)");
                ImageRequest.RequestLevel lowestPermittedRequestLevel = requestLevel;
                SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), null, requestListener2, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority(), this.config);
                dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource, (String)"{\n          val lowestPe\u2026questListener2)\n        }");
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource3 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource3;
            }
            DataSource<CloseableReference<T>> dataSource4 = dataSource;
            return dataSource4;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> DataSource<CloseableReference<T>> submitFetchRequest(@NotNull Producer<CloseableReference<T>> producerSequence, @NotNull SettableProducerContext settableProducerContext, @Nullable RequestListener requestListener) {
        Intrinsics.checkNotNullParameter(producerSequence, (String)"producerSequence");
        Intrinsics.checkNotNullParameter((Object)settableProducerContext, (String)"settableProducerContext");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ImagePipeline#submitFetchRequest";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            try {
                InternalRequestListener requestListener2 = new InternalRequestListener(requestListener, this.requestListener2);
                DataSource<CloseableReference<T>> dataSource2 = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource2, (String)"{\n          val requestL\u2026questListener2)\n        }");
                dataSource = dataSource2;
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource3 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource3, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource3;
            }
            return dataSource;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            DataSource<CloseableReference<T>> dataSource;
            boolean bl = false;
            try {
                InternalRequestListener requestListener2 = new InternalRequestListener(requestListener, this.requestListener2);
                DataSource<CloseableReference<T>> dataSource4 = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
                Intrinsics.checkNotNullExpressionValue(dataSource4, (String)"{\n          val requestL\u2026questListener2)\n        }");
                dataSource = dataSource4;
            }
            catch (Exception exception) {
                DataSource<CloseableReference<T>> dataSource5 = DataSources.immediateFailedDataSource((Throwable)exception);
                Intrinsics.checkNotNullExpressionValue((Object)dataSource5, (String)"{\n          DataSources.\u2026urce(exception)\n        }");
                dataSource = dataSource5;
            }
            DataSource<CloseableReference<T>> dataSource6 = dataSource;
            return dataSource6;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    private final DataSource<Void> submitPrefetchRequest(Producer<Void> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, Priority priority, RequestListener requestListener) {
        DataSource<Void> dataSource;
        InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.requestListener2);
        CallerContextVerifier callerContextVerifier = this.callerContextVerifier;
        if (callerContextVerifier != null) {
            callerContextVerifier.verifyCallerContext(callerContext, true);
        }
        try {
            ImageRequest.RequestLevel requestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)requestLevel), (String)"getMax(\n              im\u2026ttedRequestLevelOnSubmit)");
            ImageRequest.RequestLevel lowestPermittedRequestLevel = requestLevel;
            ImagePipelineExperiments imagePipelineExperiments = this.config.getExperiments();
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), requestListener2, callerContext, lowestPermittedRequestLevel, true, (imagePipelineExperiments != null ? imagePipelineExperiments.getAllowProgressiveOnPrefetch() : false) && imageRequest.getProgressiveRenderingEnabled(), priority, this.config);
            dataSource = ProducerToDataSourceAdapter.Companion.create(producerSequence, settableProducerContext, requestListener2);
        }
        catch (Exception exception) {
            DataSource<Void> dataSource2 = DataSources.immediateFailedDataSource((Throwable)exception);
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2, (String)"{\n      DataSources.imme\u2026taSource(exception)\n    }");
            dataSource = dataSource2;
        }
        return dataSource;
    }

    @NotNull
    public final RequestListener getRequestListenerForRequest(@Nullable ImageRequest imageRequest, @Nullable RequestListener requestListener) {
        RequestListener requestListener2;
        if (imageRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        if (requestListener == null) {
            if (imageRequest.getRequestListener() == null) {
                requestListener2 = this.requestListener;
            } else {
                RequestListener[] requestListenerArray = new RequestListener[]{this.requestListener, imageRequest.getRequestListener()};
                requestListener2 = new ForwardingRequestListener(requestListenerArray);
            }
        } else {
            ForwardingRequestListener forwardingRequestListener;
            if (imageRequest.getRequestListener() == null) {
                RequestListener[] requestListenerArray = new RequestListener[]{this.requestListener, requestListener};
                ForwardingRequestListener forwardingRequestListener2 = new ForwardingRequestListener(requestListenerArray);
                forwardingRequestListener = forwardingRequestListener2;
            } else {
                RequestListener[] requestListenerArray = new RequestListener[]{this.requestListener, requestListener, imageRequest.getRequestListener()};
                ForwardingRequestListener forwardingRequestListener3 = new ForwardingRequestListener(requestListenerArray);
                forwardingRequestListener = forwardingRequestListener3;
            }
            requestListener2 = forwardingRequestListener;
        }
        return requestListener2;
    }

    @NotNull
    public final RequestListener getCombinedRequestListener(@Nullable RequestListener listener) {
        RequestListener requestListener;
        RequestListener requestListener2 = listener;
        if (requestListener2 != null) {
            RequestListener it = requestListener2;
            boolean bl = false;
            RequestListener[] requestListenerArray = new RequestListener[]{this.requestListener, it};
            requestListener = new ForwardingRequestListener(requestListenerArray);
        } else {
            requestListener = this.requestListener;
        }
        return requestListener;
    }

    private final Predicate<CacheKey> predicateForUri(Uri uri) {
        return arg_0 -> ImagePipeline.predicateForUri$lambda$10(uri, arg_0);
    }

    public final void pause() {
        this.threadHandoffProducerQueue.startQueueing();
    }

    public final void resume() {
        this.threadHandoffProducerQueue.stopQueuing();
    }

    public final boolean isPaused() {
        return this.threadHandoffProducerQueue.isQueueing();
    }

    public final void init() {
    }

    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToEncodedCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext, @NotNull Priority priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        return ImagePipeline.prefetchToEncodedCache$default(this, imageRequest, callerContext, priority, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final DataSource<Void> prefetchToEncodedCache(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        return ImagePipeline.prefetchToEncodedCache$default(this, imageRequest, callerContext, null, null, 12, null);
    }

    private static final boolean clearMemoryCaches$lambda$2(CacheKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Task isInDiskCache$lambda$3(ImagePipeline this$0, CacheKey $cacheKey, Task task) {
        Task task2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!task.isCancelled() && !task.isFaulted()) {
            Object object = task.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.result");
            if (((Boolean)object).booleanValue()) {
                task2 = Task.forResult((Object)true);
                return task2;
            }
        }
        BufferedDiskCache bufferedDiskCache = this$0.smallImageBufferedDiskCache;
        Intrinsics.checkNotNullExpressionValue((Object)$cacheKey, (String)"cacheKey");
        task2 = bufferedDiskCache.contains($cacheKey);
        return task2;
    }

    /*
     * Unable to fully structure code
     */
    private static final Void isInDiskCache$lambda$4(SimpleDataSource $dataSource, Task task) {
        if (task.isCancelled() || task.isFaulted()) ** GOTO lbl-1000
        v0 = task.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"task.result");
        if (((Boolean)v0).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        $dataSource.setResult((Object)v1);
        return null;
    }

    private static final boolean predicateForUri$lambda$10(Uri $uri, CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key.containsUri($uri);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/imagepipeline/core/ImagePipeline$Companion;", "", "()V", "NULL_IMAGEREQUEST_EXCEPTION", "Ljava/util/concurrent/CancellationException;", "PREFETCH_EXCEPTION", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageRequest.CacheChoice.values().length];
            try {
                nArray[ImageRequest.CacheChoice.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageRequest.CacheChoice.SMALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

