/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalVideoThumbnailProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "VideoThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final ContentResolver mContentResolver;

    public LocalVideoThumbnailProducer(Executor executor, ContentResolver contentResolver) {
        this.mExecutor = executor;
        this.mContentResolver = contentResolver;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, final ProducerContext producerContext) {
        final ProducerListener2 listener = producerContext.getProducerListener();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        producerContext.putOriginExtra("local", "video");
        final StatefulProducerRunnable<CloseableReference<CloseableImage>> cancellableProducerRunnable = new StatefulProducerRunnable<CloseableReference<CloseableImage>>(consumer, listener, producerContext, PRODUCER_NAME){

            @Override
            protected void onSuccess(@Nullable CloseableReference<CloseableImage> result) {
                super.onSuccess(result);
                listener.onUltimateProducerReached(producerContext, LocalVideoThumbnailProducer.PRODUCER_NAME, result != null);
                producerContext.putOriginExtra("local");
            }

            @Override
            protected void onFailure(Exception e) {
                super.onFailure(e);
                listener.onUltimateProducerReached(producerContext, LocalVideoThumbnailProducer.PRODUCER_NAME, false);
                producerContext.putOriginExtra("local");
            }

            @Nullable
            protected CloseableReference<CloseableImage> getResult() throws Exception {
                String path;
                Bitmap thumbnailBitmap = null;
                try {
                    path = LocalVideoThumbnailProducer.this.getLocalFilePath(imageRequest);
                }
                catch (IllegalArgumentException e) {
                    path = null;
                }
                if (path != null) {
                    thumbnailBitmap = ThumbnailUtils.createVideoThumbnail((String)path, (int)LocalVideoThumbnailProducer.calculateKind(imageRequest));
                }
                if (thumbnailBitmap == null) {
                    thumbnailBitmap = LocalVideoThumbnailProducer.createThumbnailFromContentProvider(LocalVideoThumbnailProducer.this.mContentResolver, imageRequest.getSourceUri());
                }
                if (thumbnailBitmap == null) {
                    return null;
                }
                CloseableStaticBitmap closeableStaticBitmap = CloseableStaticBitmap.of((Bitmap)thumbnailBitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance(), (QualityInfo)ImmutableQualityInfo.FULL_QUALITY, (int)0);
                producerContext.putExtra("image_format", "thumbnail");
                closeableStaticBitmap.putExtras(producerContext.getExtras());
                return CloseableReference.of((Closeable)closeableStaticBitmap);
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(@Nullable CloseableReference<CloseableImage> result) {
                return ImmutableMap.of((Object)LocalVideoThumbnailProducer.CREATED_THUMBNAIL, (Object)String.valueOf(result != null));
            }

            @Override
            protected void disposeResult(@Nullable CloseableReference<CloseableImage> result) {
                CloseableReference.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    private static int calculateKind(ImageRequest imageRequest) {
        if (imageRequest.getPreferredWidth() > 96 || imageRequest.getPreferredHeight() > 96) {
            return 1;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getLocalFilePath(ImageRequest imageRequest) {
        Uri uri = imageRequest.getSourceUri();
        if (UriUtil.isLocalFileUri((Uri)uri)) {
            return imageRequest.getSourceFile().getPath();
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            String selection = null;
            String[] selectionArgs = null;
            if (Build.VERSION.SDK_INT >= 19 && "com.android.providers.media.documents".equals(uri.getAuthority())) {
                String documentId = DocumentsContract.getDocumentId((Uri)uri);
                Preconditions.checkNotNull((Object)documentId);
                uri = (Uri)Preconditions.checkNotNull((Object)MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
                selection = "_id=?";
                selectionArgs = new String[]{documentId.split(":")[1]};
            }
            try (Cursor cursor = this.mContentResolver.query(uri, new String[]{"_data"}, selection, selectionArgs, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    String string = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    return string;
                }
            }
        }
        return null;
    }

    @Nullable
    private static Bitmap createThumbnailFromContentProvider(ContentResolver contentResolver, Uri uri) {
        if (Build.VERSION.SDK_INT >= 10) {
            try {
                ParcelFileDescriptor videoFile = contentResolver.openFileDescriptor(uri, "r");
                Preconditions.checkNotNull((Object)videoFile);
                MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
                mediaMetadataRetriever.setDataSource(videoFile.getFileDescriptor());
                return mediaMetadataRetriever.getFrameAtTime(-1L);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

