/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.internal.Sets;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.imagepipeline.memory.BitmapPool;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/imagepipeline/memory/DummyTrackingInUseBitmapPool;", "Lcom/facebook/imagepipeline/memory/BitmapPool;", "()V", "inUseValues", "", "Landroid/graphics/Bitmap;", "get", "size", "", "release", "", "value", "trim", "trimType", "Lcom/facebook/common/memory/MemoryTrimType;", "imagepipeline_release"})
public final class DummyTrackingInUseBitmapPool
implements BitmapPool {
    @NotNull
    private final Set<Bitmap> inUseValues;

    public DummyTrackingInUseBitmapPool() {
        Set set = Sets.newIdentityHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newIdentityHashSet()");
        this.inUseValues = set;
    }

    public void trim(@NotNull MemoryTrimType trimType) {
        Intrinsics.checkNotNullParameter((Object)trimType, (String)"trimType");
    }

    @NotNull
    public Bitmap get(int size) {
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)((int)Math.ceil((double)size / 2.0)), (Bitmap.Config)Bitmap.Config.RGB_565);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n          \u2026   Bitmap.Config.RGB_565)");
        Bitmap result = bitmap;
        this.inUseValues.add(result);
        return result;
    }

    public void release(@NotNull Bitmap value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.inUseValues.remove(value);
        value.recycle();
    }
}

