/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.os.Build;
import androidx.core.util.Pools;
import com.facebook.common.memory.DecodeBufferHelper;
import com.facebook.imagepipeline.core.NativeCodeSetup;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.facebook.imagepipeline.platform.ArtDecoder;
import com.facebook.imagepipeline.platform.OreoDecoder;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/facebook/imagepipeline/platform/PlatformDecoderFactory;", "", "()V", "buildPlatformDecoder", "Lcom/facebook/imagepipeline/platform/PlatformDecoder;", "poolFactory", "Lcom/facebook/imagepipeline/memory/PoolFactory;", "gingerbreadDecoderEnabled", "", "useDecodeBufferHelper", "createPool", "Landroidx/core/util/Pools$Pool;", "Ljava/nio/ByteBuffer;", "imagepipeline_release"})
public final class PlatformDecoderFactory {
    @NotNull
    public static final PlatformDecoderFactory INSTANCE = new PlatformDecoderFactory();

    private PlatformDecoderFactory() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PlatformDecoder buildPlatformDecoder(@NotNull PoolFactory poolFactory, boolean gingerbreadDecoderEnabled, boolean useDecodeBufferHelper) {
        PlatformDecoder platformDecoder;
        Intrinsics.checkNotNullParameter((Object)poolFactory, (String)"poolFactory");
        if (Build.VERSION.SDK_INT >= 26) {
            BitmapPool bitmapPool = poolFactory.getBitmapPool();
            Intrinsics.checkNotNullExpressionValue((Object)bitmapPool, (String)"poolFactory.bitmapPool");
            platformDecoder = new OreoDecoder(bitmapPool, PlatformDecoderFactory.createPool(poolFactory, useDecodeBufferHelper));
        } else if (Build.VERSION.SDK_INT >= 21 || !NativeCodeSetup.getUseNativeCode()) {
            BitmapPool bitmapPool = poolFactory.getBitmapPool();
            Intrinsics.checkNotNullExpressionValue((Object)bitmapPool, (String)"poolFactory.bitmapPool");
            platformDecoder = new ArtDecoder(bitmapPool, PlatformDecoderFactory.createPool(poolFactory, useDecodeBufferHelper));
        } else {
            PlatformDecoder platformDecoder2;
            try {
                PlatformDecoder platformDecoder3;
                Class<?> clazz;
                if (gingerbreadDecoderEnabled && Build.VERSION.SDK_INT < 19) {
                    clazz = Class.forName("com.facebook.imagepipeline.platform.GingerbreadPurgeableDecoder");
                    Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.facebook.imagepipeline.platform.PlatformDecoder");
                    platformDecoder3 = (PlatformDecoder)obj;
                } else {
                    clazz = Class.forName("com.facebook.imagepipeline.platform.KitKatPurgeableDecoder");
                    Object[] objectArray = new Class[]{FlexByteArrayPool.class};
                    Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                    objectArray = new Object[]{poolFactory.getFlexByteArrayPool()};
                    Object obj = constructor.newInstance(objectArray);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.facebook.imagepipeline.platform.PlatformDecoder");
                    platformDecoder3 = (PlatformDecoder)obj;
                }
                platformDecoder2 = platformDecoder3;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            platformDecoder = platformDecoder2;
        }
        return platformDecoder;
    }

    public static /* synthetic */ PlatformDecoder buildPlatformDecoder$default(PoolFactory poolFactory, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return PlatformDecoderFactory.buildPlatformDecoder(poolFactory, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final Pools.Pool<ByteBuffer> createPool(@NotNull PoolFactory poolFactory, boolean useDecodeBufferHelper) {
        Intrinsics.checkNotNullParameter((Object)poolFactory, (String)"poolFactory");
        if (useDecodeBufferHelper) {
            DecodeBufferHelper decodeBufferHelper = DecodeBufferHelper.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)decodeBufferHelper, (String)"INSTANCE");
            return (Pools.Pool)decodeBufferHelper;
        }
        int maxNumThreads = poolFactory.getFlexByteArrayPoolMaxNumThreads();
        Pools.Pool pool = (Pools.Pool)new Pools.SynchronizedPool(maxNumThreads);
        for (int i = 0; i < maxNumThreads; ++i) {
            pool.release((Object)ByteBuffer.allocate(DecodeBufferHelper.getRecommendedDecodeBufferSize()));
        }
        return pool;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PlatformDecoder buildPlatformDecoder(@NotNull PoolFactory poolFactory, boolean gingerbreadDecoderEnabled) {
        Intrinsics.checkNotNullParameter((Object)poolFactory, (String)"poolFactory");
        return PlatformDecoderFactory.buildPlatformDecoder$default(poolFactory, gingerbreadDecoderEnabled, false, 4, null);
    }
}

