/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.core.util.Pools;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.platform.DefaultDecoder;
import com.facebook.imageutils.BitmapUtil;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/facebook/imagepipeline/platform/OreoDecoder;", "Lcom/facebook/imagepipeline/platform/DefaultDecoder;", "bitmapPool", "Lcom/facebook/imagepipeline/memory/BitmapPool;", "decodeBuffers", "Landroidx/core/util/Pools$Pool;", "Ljava/nio/ByteBuffer;", "(Lcom/facebook/imagepipeline/memory/BitmapPool;Landroidx/core/util/Pools$Pool;)V", "getBitmapSize", "", "width", "height", "options", "Landroid/graphics/BitmapFactory$Options;", "Companion", "imagepipeline_release"})
@TargetApi(value=26)
@ThreadSafe
public final class OreoDecoder
extends DefaultDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public OreoDecoder(@NotNull BitmapPool bitmapPool, @NotNull Pools.Pool<ByteBuffer> decodeBuffers) {
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        Intrinsics.checkNotNullParameter(decodeBuffers, (String)"decodeBuffers");
        super(bitmapPool, decodeBuffers);
    }

    @Override
    public int getBitmapSize(int width, int height, @NotNull BitmapFactory.Options options) {
        int n;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (OreoDecoder.Companion.hasColorGamutMismatch(options)) {
            n = width * height * 8;
        } else {
            Bitmap.Config config = options.inPreferredConfig;
            if (config == null) {
                config = Bitmap.Config.ARGB_8888;
            }
            n = BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/facebook/imagepipeline/platform/OreoDecoder$Companion;", "", "()V", "hasColorGamutMismatch", "", "options", "Landroid/graphics/BitmapFactory$Options;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasColorGamutMismatch(BitmapFactory.Options options) {
            return options.outColorSpace != null && options.outColorSpace.isWideGamut() && options.inPreferredConfig != Bitmap.Config.RGBA_F16;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

