/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.memory.LruBucketsPoolBackend;
import com.facebook.imageutils.BitmapUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/facebook/imagepipeline/memory/BitmapPoolBackend;", "Lcom/facebook/imagepipeline/memory/LruBucketsPoolBackend;", "Landroid/graphics/Bitmap;", "()V", "get", "size", "", "getSize", "bitmap", "isReusable", "", "put", "", "Companion", "imagepipeline_release"})
public class BitmapPoolBackend
extends LruBucketsPoolBackend<Bitmap> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "BitmapPoolBackend";

    @Override
    public void put(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.isReusable(bitmap)) {
            super.put(bitmap);
        }
    }

    @Override
    @Nullable
    public Bitmap get(int size) {
        Bitmap bitmap = (Bitmap)super.get(size);
        if (bitmap != null && this.isReusable(bitmap)) {
            bitmap.eraseColor(0);
            return bitmap;
        }
        return null;
    }

    @Override
    public int getSize(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return BitmapUtil.getSizeInBytes((Bitmap)bitmap);
    }

    protected final boolean isReusable(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        if (bitmap.isRecycled()) {
            Object[] objectArray = new Object[]{bitmap};
            FLog.wtf((String)TAG, (String)"Cannot reuse a recycled bitmap: %s", (Object[])objectArray);
            return false;
        }
        if (!bitmap.isMutable()) {
            Object[] objectArray = new Object[]{bitmap};
            FLog.wtf((String)TAG, (String)"Cannot reuse an immutable bitmap: %s", (Object[])objectArray);
            return false;
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/facebook/imagepipeline/memory/BitmapPoolBackend$Companion;", "", "()V", "TAG", "", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

