/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.DecodeException;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imagepipeline.transformation.BitmapTransformation;
import com.facebook.imagepipeline.transformation.CircularTransformation;
import com.facebook.imagepipeline.transformation.TransformationUtils;
import com.facebook.infer.annotation.Nullsafe;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DefaultImageDecoder
implements ImageDecoder {
    @Nullable
    private final ImageDecoder mAnimatedGifDecoder;
    @Nullable
    private final ImageDecoder mAnimatedWebPDecoder;
    private final PlatformDecoder mPlatformDecoder;
    private final ImageDecoder mDefaultDecoder = new ImageDecoder(){

        @Nullable
        public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
            ImageFormat imageFormat = encodedImage.getImageFormat();
            if (imageFormat == DefaultImageFormats.JPEG) {
                return DefaultImageDecoder.this.decodeJpeg(encodedImage, length, qualityInfo, options);
            }
            if (imageFormat == DefaultImageFormats.GIF) {
                return DefaultImageDecoder.this.decodeGif(encodedImage, length, qualityInfo, options);
            }
            if (imageFormat == DefaultImageFormats.WEBP_ANIMATED) {
                return DefaultImageDecoder.this.decodeAnimatedWebp(encodedImage, length, qualityInfo, options);
            }
            if (imageFormat == ImageFormat.UNKNOWN) {
                throw new DecodeException("unknown image format", encodedImage);
            }
            return DefaultImageDecoder.this.decodeStaticImage(encodedImage, options);
        }
    };
    @Nullable
    private final Map<ImageFormat, ImageDecoder> mCustomDecoders;

    public DefaultImageDecoder(@Nullable ImageDecoder animatedGifDecoder, @Nullable ImageDecoder animatedWebPDecoder, PlatformDecoder platformDecoder) {
        this(animatedGifDecoder, animatedWebPDecoder, platformDecoder, null);
    }

    public DefaultImageDecoder(@Nullable ImageDecoder animatedGifDecoder, @Nullable ImageDecoder animatedWebPDecoder, PlatformDecoder platformDecoder, @Nullable Map<ImageFormat, ImageDecoder> customDecoders) {
        this.mAnimatedGifDecoder = animatedGifDecoder;
        this.mAnimatedWebPDecoder = animatedWebPDecoder;
        this.mPlatformDecoder = platformDecoder;
        this.mCustomDecoders = customDecoders;
    }

    @Nullable
    public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        ImageDecoder decoder;
        InputStream inputStream;
        if (options.customImageDecoder != null) {
            return options.customImageDecoder.decode(encodedImage, length, qualityInfo, options);
        }
        ImageFormat imageFormat = encodedImage.getImageFormat();
        if ((imageFormat == null || imageFormat == ImageFormat.UNKNOWN) && (inputStream = encodedImage.getInputStream()) != null) {
            imageFormat = ImageFormatChecker.getImageFormat_WrapIOException((InputStream)inputStream);
            encodedImage.setImageFormat(imageFormat);
        }
        if (this.mCustomDecoders != null && (decoder = this.mCustomDecoders.get(imageFormat)) != null) {
            return decoder.decode(encodedImage, length, qualityInfo, options);
        }
        return this.mDefaultDecoder.decode(encodedImage, length, qualityInfo, options);
    }

    @Nullable
    public CloseableImage decodeGif(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        if (encodedImage.getWidth() == -1 || encodedImage.getHeight() == -1) {
            throw new DecodeException("image width or height is incorrect", encodedImage);
        }
        if (!options.forceStaticImage && this.mAnimatedGifDecoder != null) {
            return this.mAnimatedGifDecoder.decode(encodedImage, length, qualityInfo, options);
        }
        return this.decodeStaticImage(encodedImage, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableStaticBitmap decodeStaticImage(EncodedImage encodedImage, ImageDecodeOptions options) {
        try (CloseableReference<Bitmap> bitmapReference = this.mPlatformDecoder.decodeFromEncodedImageWithColorSpace(encodedImage, options.bitmapConfig, null, options.colorSpace);){
            boolean didApplyTransformation = TransformationUtils.maybeApplyTransformation((BitmapTransformation)options.bitmapTransformation, bitmapReference);
            CloseableStaticBitmap closeableStaticBitmap = CloseableStaticBitmap.of(bitmapReference, (QualityInfo)ImmutableQualityInfo.FULL_QUALITY, (int)encodedImage.getRotationAngle(), (int)encodedImage.getExifOrientation());
            closeableStaticBitmap.putExtra("is_rounded", (Object)(didApplyTransformation && options.bitmapTransformation instanceof CircularTransformation ? 1 : 0));
            CloseableStaticBitmap closeableStaticBitmap2 = closeableStaticBitmap;
            return closeableStaticBitmap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableStaticBitmap decodeJpeg(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        try (CloseableReference<Bitmap> bitmapReference = this.mPlatformDecoder.decodeJPEGFromEncodedImageWithColorSpace(encodedImage, options.bitmapConfig, null, length, options.colorSpace);){
            boolean didApplyTransformation = TransformationUtils.maybeApplyTransformation((BitmapTransformation)options.bitmapTransformation, bitmapReference);
            CloseableStaticBitmap closeableStaticBitmap = CloseableStaticBitmap.of(bitmapReference, (QualityInfo)qualityInfo, (int)encodedImage.getRotationAngle(), (int)encodedImage.getExifOrientation());
            closeableStaticBitmap.putExtra("is_rounded", (Object)(didApplyTransformation && options.bitmapTransformation instanceof CircularTransformation ? 1 : 0));
            CloseableStaticBitmap closeableStaticBitmap2 = closeableStaticBitmap;
            return closeableStaticBitmap2;
        }
    }

    @Nullable
    public CloseableImage decodeAnimatedWebp(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        if (!options.forceStaticImage && this.mAnimatedWebPDecoder != null) {
            return this.mAnimatedWebPDecoder.decode(encodedImage, length, qualityInfo, options);
        }
        return this.decodeStaticImage(encodedImage, options);
    }
}

