/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.ContactsContract;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalContentUriFetchProducer
extends LocalFetchProducer {
    public static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    private static final String[] PROJECTION = new String[]{"_id", "_data"};
    private final ContentResolver mContentResolver;

    public LocalContentUriFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        super(executor, pooledByteBufferFactory);
        this.mContentResolver = contentResolver;
    }

    @Override
    protected EncodedImage getEncodedImage(ImageRequest imageRequest) throws IOException {
        EncodedImage cameraImage;
        Uri uri = imageRequest.getSourceUri();
        if (UriUtil.isLocalContactUri((Uri)uri)) {
            InputStream inputStream;
            if (uri.toString().endsWith("/photo")) {
                inputStream = this.mContentResolver.openInputStream(uri);
            } else if (uri.toString().endsWith("/display_photo")) {
                try {
                    AssetFileDescriptor fd = this.mContentResolver.openAssetFileDescriptor(uri, "r");
                    Preconditions.checkNotNull((Object)fd);
                    inputStream = fd.createInputStream();
                }
                catch (IOException e) {
                    throw new IOException("Contact photo does not exist: " + uri);
                }
            } else {
                inputStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.mContentResolver, (Uri)uri);
                if (inputStream == null) {
                    throw new IOException("Contact photo does not exist: " + uri);
                }
            }
            Preconditions.checkNotNull((Object)inputStream);
            return this.getEncodedImage(inputStream, -1);
        }
        if (UriUtil.isLocalCameraUri((Uri)uri) && (cameraImage = this.getCameraImage(uri)) != null) {
            return cameraImage;
        }
        return this.getEncodedImage((InputStream)Preconditions.checkNotNull((Object)this.mContentResolver.openInputStream(uri)), -1);
    }

    @Nullable
    private EncodedImage getCameraImage(Uri uri) throws IOException {
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mContentResolver.openFileDescriptor(uri, "r");
            Preconditions.checkNotNull((Object)parcelFileDescriptor);
            FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
            return this.getEncodedImage(new FileInputStream(fd), (int)parcelFileDescriptor.getStatSize());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

