/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public final class ThumbnailSizeChecker {
    public static final float ACCEPTABLE_REQUESTED_TO_ACTUAL_SIZE_RATIO = 1.3333334f;
    private static final int ROTATED_90_DEGREES_CLOCKWISE = 90;
    private static final int ROTATED_90_DEGREES_COUNTER_CLOCKWISE = 270;

    public static boolean isImageBigEnough(int width, int height, @Nullable ResizeOptions resizeOptions) {
        if (resizeOptions == null) {
            return (float)ThumbnailSizeChecker.getAcceptableSize(width) >= 2048.0f && ThumbnailSizeChecker.getAcceptableSize(height) >= 2048;
        }
        return ThumbnailSizeChecker.getAcceptableSize(width) >= resizeOptions.width && ThumbnailSizeChecker.getAcceptableSize(height) >= resizeOptions.height;
    }

    public static boolean isImageBigEnough(@Nullable EncodedImage encodedImage, @Nullable ResizeOptions resizeOptions) {
        if (encodedImage == null) {
            return false;
        }
        switch (encodedImage.getRotationAngle()) {
            case 90: 
            case 270: {
                return ThumbnailSizeChecker.isImageBigEnough(encodedImage.getHeight(), encodedImage.getWidth(), resizeOptions);
            }
        }
        return ThumbnailSizeChecker.isImageBigEnough(encodedImage.getWidth(), encodedImage.getHeight(), resizeOptions);
    }

    public static int getAcceptableSize(int size) {
        return (int)((float)size * 1.3333334f);
    }
}

