/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.filter.InPlaceRoundFilter;
import com.facebook.imagepipeline.filter.XferRoundFilter;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class RoundPostprocessor
extends BasePostprocessor {
    private static final boolean ENABLE_ANTI_ALIASING = true;
    private static final boolean canUseXferRoundFilter = XferRoundFilter.canUseXferRoundFilter();
    @Nullable
    private CacheKey mCacheKey;
    private final boolean mEnableAntiAliasing;

    public RoundPostprocessor() {
        this(true);
    }

    public RoundPostprocessor(boolean enableAntiAliasing) {
        this.mEnableAntiAliasing = enableAntiAliasing;
    }

    @Override
    public void process(Bitmap destBitmap, Bitmap sourceBitmap) {
        Preconditions.checkNotNull((Object)destBitmap);
        Preconditions.checkNotNull((Object)sourceBitmap);
        if (canUseXferRoundFilter) {
            XferRoundFilter.xferRoundBitmap(destBitmap, sourceBitmap, this.mEnableAntiAliasing);
        } else {
            super.process(destBitmap, sourceBitmap);
        }
    }

    @Override
    public void process(Bitmap bitmap) {
        InPlaceRoundFilter.roundBitmapInPlace(bitmap);
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        if (this.mCacheKey == null) {
            this.mCacheKey = canUseXferRoundFilter ? new SimpleCacheKey("XferRoundFilter") : new SimpleCacheKey("InPlaceRoundFilter");
        }
        return this.mCacheKey;
    }
}

