/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class MemoryChunkUtil {
    static int adjustByteCount(int offset, int count, int memorySize) {
        int available = Math.max(0, memorySize - offset);
        return Math.min(available, count);
    }

    static void checkBounds(int offset, int otherLength, int otherOffset, int count, int memorySize) {
        Preconditions.checkArgument((Boolean)(count >= 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(offset >= 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(otherOffset >= 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(offset + count <= memorySize ? 1 : 0));
        Preconditions.checkArgument((Boolean)(otherOffset + count <= otherLength ? 1 : 0));
    }
}

