/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.core.NativeCodeSetup;
import com.facebook.imagepipeline.request.Postprocessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public abstract class BasePostprocessor
implements Postprocessor {
    public static final Bitmap.Config FALLBACK_BITMAP_CONFIGURATION = Bitmap.Config.ARGB_8888;
    private static Method sCopyBitmap;

    @Override
    public String getName() {
        return "Unknown postprocessor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
        Bitmap.Config sourceBitmapConfig = sourceBitmap.getConfig();
        CloseableReference destBitmapRef = bitmapFactory.createBitmapInternal(sourceBitmap.getWidth(), sourceBitmap.getHeight(), sourceBitmapConfig != null ? sourceBitmapConfig : FALLBACK_BITMAP_CONFIGURATION);
        try {
            this.process((Bitmap)destBitmapRef.get(), sourceBitmap);
            CloseableReference closeableReference = CloseableReference.cloneOrNull((CloseableReference)destBitmapRef);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)destBitmapRef);
        }
    }

    public void process(Bitmap destBitmap, Bitmap sourceBitmap) {
        BasePostprocessor.internalCopyBitmap(destBitmap, sourceBitmap);
        this.process(destBitmap);
    }

    public void process(Bitmap bitmap) {
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        return null;
    }

    private static void internalCopyBitmap(Bitmap destBitmap, Bitmap sourceBitmap) {
        if (NativeCodeSetup.getUseNativeCode() && destBitmap.getConfig() == sourceBitmap.getConfig()) {
            try {
                if (sCopyBitmap == null) {
                    Class<?> clazz = Class.forName("com.facebook.imagepipeline.nativecode.Bitmaps");
                    sCopyBitmap = clazz.getDeclaredMethod("copyBitmap", Bitmap.class, Bitmap.class);
                }
                sCopyBitmap.invoke(null, destBitmap, sourceBitmap);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
            }
        }
        Canvas canvas = new Canvas(destBitmap);
        canvas.drawBitmap(sourceBitmap, 0.0f, 0.0f, null);
    }
}

