/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.os.Build;
import androidx.core.util.Pools;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.facebook.imagepipeline.platform.ArtDecoder;
import com.facebook.imagepipeline.platform.GingerbreadPurgeableDecoder;
import com.facebook.imagepipeline.platform.KitKatPurgeableDecoder;
import com.facebook.imagepipeline.platform.OreoDecoder;
import com.facebook.imagepipeline.platform.PlatformDecoder;

public class PlatformDecoderFactory {
    public static PlatformDecoder buildPlatformDecoder(PoolFactory poolFactory, boolean gingerbreadDecoderEnabled) {
        if (Build.VERSION.SDK_INT >= 26) {
            int maxNumThreads = poolFactory.getFlexByteArrayPoolMaxNumThreads();
            return new OreoDecoder(poolFactory.getBitmapPool(), maxNumThreads, new Pools.SynchronizedPool(maxNumThreads));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            int maxNumThreads = poolFactory.getFlexByteArrayPoolMaxNumThreads();
            return new ArtDecoder(poolFactory.getBitmapPool(), maxNumThreads, new Pools.SynchronizedPool(maxNumThreads));
        }
        if (gingerbreadDecoderEnabled && Build.VERSION.SDK_INT < 19) {
            return new GingerbreadPurgeableDecoder();
        }
        return new KitKatPurgeableDecoder(poolFactory.getFlexByteArrayPool());
    }
}

