/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=11)
@ThreadSafe
public class HoneycombBitmapFactory
extends PlatformBitmapFactory {
    private static final String TAG = HoneycombBitmapFactory.class.getSimpleName();
    private final EmptyJpegGenerator mJpegGenerator;
    private final PlatformDecoder mPurgeableDecoder;
    private final CloseableReferenceFactory mCloseableReferenceFactory;
    private boolean mImmutableBitmapFallback;

    public HoneycombBitmapFactory(EmptyJpegGenerator jpegGenerator, PlatformDecoder purgeableDecoder, CloseableReferenceFactory closeableReferenceFactory) {
        this.mJpegGenerator = jpegGenerator;
        this.mPurgeableDecoder = purgeableDecoder;
        this.mCloseableReferenceFactory = closeableReferenceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=12)
    public CloseableReference<Bitmap> createBitmapInternal(int width, int height, Bitmap.Config bitmapConfig) {
        if (this.mImmutableBitmapFallback) {
            return this.createFallbackBitmap(width, height, bitmapConfig);
        }
        try (CloseableReference<PooledByteBuffer> jpgRef = this.mJpegGenerator.generate((short)width, (short)height);){
            CloseableReference<Bitmap> bitmapRef;
            EncodedImage encodedImage;
            block9: {
                CloseableReference<Bitmap> closeableReference;
                encodedImage = new EncodedImage(jpgRef);
                encodedImage.setImageFormat(DefaultImageFormats.JPEG);
                try {
                    bitmapRef = this.mPurgeableDecoder.decodeJPEGFromEncodedImage(encodedImage, bitmapConfig, null, ((PooledByteBuffer)jpgRef.get()).size());
                    if (((Bitmap)bitmapRef.get()).isMutable()) break block9;
                    CloseableReference.closeSafely(bitmapRef);
                    this.mImmutableBitmapFallback = true;
                    FLog.wtf((String)TAG, (String)"Immutable bitmap returned by decoder");
                    closeableReference = this.createFallbackBitmap(width, height, bitmapConfig);
                }
                catch (Throwable throwable) {
                    EncodedImage.closeSafely((EncodedImage)encodedImage);
                    throw throwable;
                }
                EncodedImage.closeSafely((EncodedImage)encodedImage);
                return closeableReference;
            }
            ((Bitmap)bitmapRef.get()).setHasAlpha(true);
            ((Bitmap)bitmapRef.get()).eraseColor(0);
            CloseableReference<Bitmap> closeableReference = bitmapRef;
            EncodedImage.closeSafely((EncodedImage)encodedImage);
            return closeableReference;
        }
    }

    private CloseableReference<Bitmap> createFallbackBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        return this.mCloseableReferenceFactory.create(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig), SimpleBitmapReleaser.getInstance());
    }
}

