/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MediaVariationsIndex;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.MediaVariations;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class MediaVariationsFallbackProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "MediaVariationsFallbackProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    public static final String EXTRA_CACHED_VALUE_USED_AS_LAST = "cached_value_used_as_last";
    public static final String EXTRA_VARIANTS_COUNT = "variants_count";
    public static final String EXTRA_VARIANTS_SOURCE = "variants_source";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final MediaVariationsIndex mMediaVariationsIndex;
    private final Producer<EncodedImage> mInputProducer;

    public MediaVariationsFallbackProducer(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, MediaVariationsIndex mediaVariationsIndex, Producer<EncodedImage> inputProducer) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mMediaVariationsIndex = mediaVariationsIndex;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(final Consumer<EncodedImage> consumer, final ProducerContext producerContext) {
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        final MediaVariations mediaVariations = imageRequest.getMediaVariations();
        if (!imageRequest.isDiskCacheEnabled() || resizeOptions == null || resizeOptions.height <= 0 || resizeOptions.width <= 0 || imageRequest.getBytesRange() != null) {
            this.startInputProducerWithExistingConsumer(consumer, producerContext);
            return;
        }
        if (mediaVariations == null) {
            this.startInputProducerWithExistingConsumer(consumer, producerContext);
            return;
        }
        producerContext.getListener().onProducerStart(producerContext.getId(), PRODUCER_NAME);
        final AtomicBoolean isCancelled = new AtomicBoolean(false);
        if (mediaVariations.getVariantsCount() > 0) {
            this.chooseFromVariants(consumer, producerContext, imageRequest, mediaVariations, resizeOptions, isCancelled);
        } else {
            MediaVariations.Builder mediaVariationsBuilder = MediaVariations.newBuilderForMediaId(mediaVariations.getMediaId()).setForceRequestForSpecifiedUri(mediaVariations.shouldForceRequestForSpecifiedUri()).setSource("index_db");
            Task<MediaVariations> indexedMediaVariationsTask = this.mMediaVariationsIndex.getCachedVariants(mediaVariations.getMediaId(), mediaVariationsBuilder);
            indexedMediaVariationsTask.continueWith((Continuation)new Continuation<MediaVariations, Object>(){

                public Object then(Task<MediaVariations> task) throws Exception {
                    if (task.isCancelled() || task.isFaulted()) {
                        return task;
                    }
                    try {
                        if (task.getResult() == null) {
                            MediaVariationsFallbackProducer.this.startInputProducerWithWrappedConsumer(consumer, producerContext, mediaVariations.getMediaId());
                            return null;
                        }
                        return MediaVariationsFallbackProducer.this.chooseFromVariants(consumer, producerContext, imageRequest, (MediaVariations)task.getResult(), resizeOptions, isCancelled);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    private Task chooseFromVariants(Consumer<EncodedImage> consumer, ProducerContext producerContext, ImageRequest imageRequest, MediaVariations mediaVariations, ResizeOptions resizeOptions, AtomicBoolean isCancelled) {
        if (mediaVariations.getVariantsCount() == 0) {
            Continuation<EncodedImage, Void> continuation = this.onFinishDiskReads(consumer, producerContext, imageRequest, mediaVariations, Collections.emptyList(), 0, isCancelled);
            return Task.forResult((Object)null).continueWith(continuation);
        }
        List<MediaVariations.Variant> sortedVariants = mediaVariations.getSortedVariants(new VariantComparator(resizeOptions));
        return this.attemptCacheReadForVariant(consumer, producerContext, imageRequest, mediaVariations, sortedVariants, 0, isCancelled);
    }

    private Task attemptCacheReadForVariant(Consumer<EncodedImage> consumer, ProducerContext producerContext, ImageRequest imageRequest, MediaVariations mediaVariations, List<MediaVariations.Variant> sortedVariants, int index, AtomicBoolean isCancelled) {
        MediaVariations.Variant variant = sortedVariants.get(index);
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, variant.getUri(), producerContext.getCallerContext());
        ImageRequest.CacheChoice cacheChoice = variant.getCacheChoice() == null ? imageRequest.getCacheChoice() : variant.getCacheChoice();
        BufferedDiskCache preferredCache = cacheChoice == ImageRequest.CacheChoice.SMALL ? this.mSmallImageBufferedDiskCache : this.mDefaultBufferedDiskCache;
        Task<EncodedImage> readTask = preferredCache.get(cacheKey, isCancelled);
        Continuation<EncodedImage, Void> continuation = this.onFinishDiskReads(consumer, producerContext, imageRequest, mediaVariations, sortedVariants, index, isCancelled);
        return readTask.continueWith(continuation);
    }

    private static boolean isBigEnoughForRequestedSize(MediaVariations.Variant variant, ResizeOptions resizeOptions) {
        return variant.getWidth() >= resizeOptions.width && variant.getHeight() >= resizeOptions.height;
    }

    private Continuation<EncodedImage, Void> onFinishDiskReads(final Consumer<EncodedImage> consumer, final ProducerContext producerContext, final ImageRequest imageRequest, final MediaVariations mediaVariations, final List<MediaVariations.Variant> sortedVariants, final int variantsIndex, final AtomicBoolean isCancelled) {
        final String requestId = producerContext.getId();
        final ProducerListener listener = producerContext.getListener();
        return new Continuation<EncodedImage, Void>(){

            public Void then(Task<EncodedImage> task) throws Exception {
                boolean allowIntermediateResults;
                boolean triggerNextProducer;
                if (MediaVariationsFallbackProducer.isTaskCancelled(task)) {
                    listener.onProducerFinishWithCancellation(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                    triggerNextProducer = false;
                    allowIntermediateResults = false;
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, task.getError(), null);
                    MediaVariationsFallbackProducer.this.startInputProducerWithWrappedConsumer(consumer, producerContext, mediaVariations.getMediaId());
                    triggerNextProducer = true;
                    allowIntermediateResults = true;
                } else {
                    EncodedImage cachedReference = (EncodedImage)task.getResult();
                    if (cachedReference != null) {
                        boolean useAsLastResult = !mediaVariations.shouldForceRequestForSpecifiedUri() && MediaVariationsFallbackProducer.isBigEnoughForRequestedSize((MediaVariations.Variant)sortedVariants.get(variantsIndex), imageRequest.getResizeOptions());
                        listener.onProducerFinishWithSuccess(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, MediaVariationsFallbackProducer.getExtraMap(listener, requestId, true, sortedVariants.size(), mediaVariations.getSource(), useAsLastResult));
                        if (useAsLastResult) {
                            listener.onUltimateProducerReached(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, true);
                            consumer.onProgressUpdate(1.0f);
                        }
                        int status = BaseConsumer.simpleStatusForIsLast(useAsLastResult);
                        status = BaseConsumer.turnOnStatusFlag(status, 2);
                        if (!useAsLastResult) {
                            status = BaseConsumer.turnOnStatusFlag(status, 4);
                        }
                        consumer.onNewResult(cachedReference, status);
                        cachedReference.close();
                        triggerNextProducer = !useAsLastResult;
                        allowIntermediateResults = false;
                    } else if (variantsIndex < sortedVariants.size() - 1) {
                        MediaVariationsFallbackProducer.this.attemptCacheReadForVariant(consumer, producerContext, imageRequest, mediaVariations, sortedVariants, variantsIndex + 1, isCancelled);
                        triggerNextProducer = false;
                        allowIntermediateResults = false;
                    } else {
                        listener.onProducerFinishWithSuccess(requestId, MediaVariationsFallbackProducer.PRODUCER_NAME, MediaVariationsFallbackProducer.getExtraMap(listener, requestId, false, sortedVariants.size(), mediaVariations.getSource(), false));
                        triggerNextProducer = true;
                        allowIntermediateResults = true;
                    }
                }
                if (triggerNextProducer) {
                    ProducerContext forwardedProducerContext;
                    if (producerContext.isIntermediateResultExpected() && !allowIntermediateResults) {
                        SettableProducerContext settableContext = new SettableProducerContext(producerContext);
                        settableContext.setIsIntermediateResultExpected(false);
                        forwardedProducerContext = settableContext;
                    } else {
                        forwardedProducerContext = producerContext;
                    }
                    MediaVariationsFallbackProducer.this.startInputProducerWithWrappedConsumer(consumer, forwardedProducerContext, mediaVariations.getMediaId());
                }
                return null;
            }
        };
    }

    private void startInputProducerWithExistingConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        this.mInputProducer.produceResults(consumer, producerContext);
    }

    private void startInputProducerWithWrappedConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, String mediaId) {
        this.mInputProducer.produceResults(new MediaVariationsConsumer(consumer, producerContext, mediaId), producerContext);
    }

    private static boolean isTaskCancelled(Task<?> task) {
        return task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException;
    }

    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener listener, String requestId, boolean valueFound, int variantsCount, String variantsSource, boolean useAsLastResult) {
        if (!listener.requiresExtraMap(requestId)) {
            return null;
        }
        if (valueFound) {
            return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(true), (Object)EXTRA_CACHED_VALUE_USED_AS_LAST, (Object)String.valueOf(useAsLastResult), (Object)EXTRA_VARIANTS_COUNT, (Object)String.valueOf(variantsCount), (Object)EXTRA_VARIANTS_SOURCE, (Object)variantsSource);
        }
        return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(false), (Object)EXTRA_VARIANTS_COUNT, (Object)String.valueOf(variantsCount), (Object)EXTRA_VARIANTS_SOURCE, (Object)variantsSource);
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    @VisibleForTesting
    static class VariantComparator
    implements Comparator<MediaVariations.Variant> {
        private final ResizeOptions mResizeOptions;

        VariantComparator(ResizeOptions resizeOptions) {
            this.mResizeOptions = resizeOptions;
        }

        @Override
        public int compare(MediaVariations.Variant o1, MediaVariations.Variant o2) {
            boolean o1BigEnough = MediaVariationsFallbackProducer.isBigEnoughForRequestedSize(o1, this.mResizeOptions);
            boolean o2BigEnough = MediaVariationsFallbackProducer.isBigEnoughForRequestedSize(o2, this.mResizeOptions);
            if (o1BigEnough && o2BigEnough) {
                return o1.getWidth() - o2.getWidth();
            }
            if (o1BigEnough) {
                return -1;
            }
            if (o2BigEnough) {
                return 1;
            }
            return o2.getWidth() - o1.getWidth();
        }
    }

    @VisibleForTesting
    class MediaVariationsConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private final String mMediaId;

        public MediaVariationsConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, String mediaId) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mMediaId = mediaId;
        }

        @Override
        protected void onNewResultImpl(EncodedImage newResult, int status) {
            if (MediaVariationsConsumer.isLast(status) && newResult != null && !MediaVariationsConsumer.statusHasFlag(status, 8)) {
                this.storeResultInDatabase(newResult);
            }
            this.getConsumer().onNewResult(newResult, status);
        }

        private void storeResultInDatabase(EncodedImage newResult) {
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            if (!imageRequest.isDiskCacheEnabled() || this.mMediaId == null) {
                return;
            }
            ImageRequest.CacheChoice cacheChoice = imageRequest.getCacheChoice() == null ? ImageRequest.CacheChoice.DEFAULT : imageRequest.getCacheChoice();
            CacheKey cacheKey = MediaVariationsFallbackProducer.this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, this.mProducerContext.getCallerContext());
            MediaVariationsFallbackProducer.this.mMediaVariationsIndex.saveCachedVariant(this.mMediaId, cacheChoice, cacheKey, newResult);
        }
    }
}

