/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;

public class BitmapPrepareProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "BitmapPrepareProducer";
    private final Producer<CloseableReference<CloseableImage>> mInputProducer;
    private final int mMinBitmapSizeBytes;
    private final int mMaxBitmapSizeBytes;

    public BitmapPrepareProducer(Producer<CloseableReference<CloseableImage>> inputProducer, int minBitmapSizeBytes, int maxBitmapSizeBytes) {
        Preconditions.checkArgument((minBitmapSizeBytes <= maxBitmapSizeBytes ? 1 : 0) != 0);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mMinBitmapSizeBytes = minBitmapSizeBytes;
        this.mMaxBitmapSizeBytes = maxBitmapSizeBytes;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        if (producerContext.isPrefetch()) {
            this.mInputProducer.produceResults(consumer, producerContext);
        } else {
            this.mInputProducer.produceResults(new BitmapPrepareConsumer(consumer, this.mMinBitmapSizeBytes, this.mMaxBitmapSizeBytes), producerContext);
        }
    }

    private static class BitmapPrepareConsumer
    extends DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>> {
        private final int mMinBitmapSizeBytes;
        private final int mMaxBitmapSizeBytes;

        BitmapPrepareConsumer(Consumer<CloseableReference<CloseableImage>> consumer, int minBitmapSizeBytes, int maxBitmapSizeBytes) {
            super(consumer);
            this.mMinBitmapSizeBytes = minBitmapSizeBytes;
            this.mMaxBitmapSizeBytes = maxBitmapSizeBytes;
        }

        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, int status) {
            this.internalPrepareBitmap(newResult);
            this.getConsumer().onNewResult(newResult, status);
        }

        private void internalPrepareBitmap(CloseableReference<CloseableImage> newResult) {
            if (newResult == null || !newResult.isValid()) {
                return;
            }
            CloseableImage closeableImage = (CloseableImage)newResult.get();
            if (closeableImage == null || closeableImage.isClosed()) {
                return;
            }
            if (closeableImage instanceof CloseableStaticBitmap) {
                CloseableStaticBitmap staticBitmap = (CloseableStaticBitmap)closeableImage;
                Bitmap bitmap = staticBitmap.getUnderlyingBitmap();
                if (bitmap == null) {
                    return;
                }
                int bitmapByteCount = bitmap.getRowBytes() * bitmap.getHeight();
                if (bitmapByteCount < this.mMinBitmapSizeBytes) {
                    return;
                }
                if (bitmapByteCount > this.mMaxBitmapSizeBytes) {
                    return;
                }
                bitmap.prepareToDraw();
            }
        }
    }
}

