/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.support.annotation.Nullable;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.BucketMap;
import com.facebook.imagepipeline.memory.PoolBackend;
import java.util.HashSet;
import java.util.Set;

public abstract class LruBucketsPoolBackend<T>
implements PoolBackend<T> {
    private final Set<T> mCurrentItems = new HashSet<T>();
    private final BucketMap<T> mMap = new BucketMap();

    @Override
    @Nullable
    public T get(int size) {
        return this.maybeRemoveFromCurrentItems(this.mMap.acquire(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T item) {
        boolean wasAdded;
        LruBucketsPoolBackend lruBucketsPoolBackend = this;
        synchronized (lruBucketsPoolBackend) {
            wasAdded = this.mCurrentItems.add(item);
        }
        if (wasAdded) {
            this.mMap.release(this.getSize(item), item);
        }
    }

    @Override
    @Nullable
    public T pop() {
        return this.maybeRemoveFromCurrentItems(this.mMap.removeFromEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T maybeRemoveFromCurrentItems(@Nullable T t) {
        if (t != null) {
            LruBucketsPoolBackend lruBucketsPoolBackend = this;
            synchronized (lruBucketsPoolBackend) {
                this.mCurrentItems.remove(t);
            }
        }
        return t;
    }

    @VisibleForTesting
    int valueCount() {
        return this.mMap.valueCount();
    }
}

