/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.annotation.SuppressLint;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Sets;
import com.facebook.common.internal.Throwables;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.Pool;
import com.facebook.imagepipeline.memory.Bucket;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;

public abstract class BasePool<V>
implements Pool<V> {
    private final Class<?> TAG = this.getClass();
    final MemoryTrimmableRegistry mMemoryTrimmableRegistry;
    final PoolParams mPoolParams;
    @VisibleForTesting
    final SparseArray<Bucket<V>> mBuckets;
    @VisibleForTesting
    final Set<V> mInUseValues;
    private boolean mAllowNewBuckets;
    @VisibleForTesting
    @GuardedBy(value="this")
    final Counter mUsed;
    @VisibleForTesting
    @GuardedBy(value="this")
    final Counter mFree;
    private final PoolStatsTracker mPoolStatsTracker;

    public BasePool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker poolStatsTracker) {
        this.mMemoryTrimmableRegistry = (MemoryTrimmableRegistry)Preconditions.checkNotNull((Object)memoryTrimmableRegistry);
        this.mPoolParams = (PoolParams)Preconditions.checkNotNull((Object)poolParams);
        this.mPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)poolStatsTracker);
        this.mBuckets = new SparseArray();
        if (this.mPoolParams.fixBucketsReinitialization) {
            this.initBuckets();
        } else {
            this.legacyInitBuckets(new SparseIntArray(0));
        }
        this.mInUseValues = Sets.newIdentityHashSet();
        this.mFree = new Counter();
        this.mUsed = new Counter();
    }

    protected void initialize() {
        this.mMemoryTrimmableRegistry.registerMemoryTrimmable((MemoryTrimmable)this);
        this.mPoolStatsTracker.setBasePool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int size) {
        this.ensurePoolSizeInvariant();
        int bucketedSize = this.getBucketedSize(size);
        int sizeInBytes = -1;
        BasePool basePool = this;
        synchronized (basePool) {
            V value;
            Bucket<V> bucket = this.getBucket(bucketedSize);
            if (bucket != null && (value = bucket.get()) != null) {
                Preconditions.checkState((boolean)this.mInUseValues.add(value));
                bucketedSize = this.getBucketedSizeForValue(value);
                sizeInBytes = this.getSizeInBytes(bucketedSize);
                this.mUsed.increment(sizeInBytes);
                this.mFree.decrement(sizeInBytes);
                this.mPoolStatsTracker.onValueReuse(sizeInBytes);
                this.logStats();
                if (FLog.isLoggable((int)2)) {
                    FLog.v(this.TAG, (String)"get (reuse) (object, size) = (%x, %s)", (Object)System.identityHashCode(value), (Object)bucketedSize);
                }
                return value;
            }
            sizeInBytes = this.getSizeInBytes(bucketedSize);
            if (!this.canAllocate(sizeInBytes)) {
                throw new PoolSizeViolationException(this.mPoolParams.maxSizeHardCap, this.mUsed.mNumBytes, this.mFree.mNumBytes, sizeInBytes);
            }
            this.mUsed.increment(sizeInBytes);
            if (bucket != null) {
                bucket.incrementInUseCount();
            }
        }
        V value = null;
        try {
            value = this.alloc(bucketedSize);
        }
        catch (Throwable e) {
            BasePool basePool2 = this;
            synchronized (basePool2) {
                this.mUsed.decrement(sizeInBytes);
                Bucket<V> bucket = this.getBucket(bucketedSize);
                if (bucket != null) {
                    bucket.decrementInUseCount();
                }
            }
            Throwables.propagateIfPossible((Throwable)e);
        }
        BasePool basePool3 = this;
        synchronized (basePool3) {
            Preconditions.checkState((boolean)this.mInUseValues.add(value));
            this.trimToSoftCap();
            this.mPoolStatsTracker.onAlloc(sizeInBytes);
            this.logStats();
            if (FLog.isLoggable((int)2)) {
                FLog.v(this.TAG, (String)"get (alloc) (object, size) = (%x, %s)", (Object)System.identityHashCode(value), (Object)bucketedSize);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(V value) {
        Preconditions.checkNotNull(value);
        int bucketedSize = this.getBucketedSizeForValue(value);
        int sizeInBytes = this.getSizeInBytes(bucketedSize);
        BasePool basePool = this;
        synchronized (basePool) {
            Bucket<V> bucket = this.getBucketIfPresent(bucketedSize);
            if (!this.mInUseValues.remove(value)) {
                FLog.e(this.TAG, (String)"release (free, value unrecognized) (object, size) = (%x, %s)", (Object[])new Object[]{System.identityHashCode(value), bucketedSize});
                this.free(value);
                this.mPoolStatsTracker.onFree(sizeInBytes);
            } else if (bucket == null || bucket.isMaxLengthExceeded() || this.isMaxSizeSoftCapExceeded() || !this.isReusable(value)) {
                if (bucket != null) {
                    bucket.decrementInUseCount();
                }
                if (FLog.isLoggable((int)2)) {
                    FLog.v(this.TAG, (String)"release (free) (object, size) = (%x, %s)", (Object)System.identityHashCode(value), (Object)bucketedSize);
                }
                this.free(value);
                this.mUsed.decrement(sizeInBytes);
                this.mPoolStatsTracker.onFree(sizeInBytes);
            } else {
                bucket.release(value);
                this.mFree.increment(sizeInBytes);
                this.mUsed.decrement(sizeInBytes);
                this.mPoolStatsTracker.onValueRelease(sizeInBytes);
                if (FLog.isLoggable((int)2)) {
                    FLog.v(this.TAG, (String)"release (reuse) (object, size) = (%x, %s)", (Object)System.identityHashCode(value), (Object)bucketedSize);
                }
            }
            this.logStats();
        }
    }

    public void trim(MemoryTrimType memoryTrimType) {
        this.trimToNothing();
    }

    protected abstract V alloc(int var1);

    @VisibleForTesting
    protected abstract void free(V var1);

    protected abstract int getBucketedSize(int var1);

    protected abstract int getBucketedSizeForValue(V var1);

    protected abstract int getSizeInBytes(int var1);

    protected void onParamsChanged() {
    }

    protected boolean isReusable(V value) {
        Preconditions.checkNotNull(value);
        return true;
    }

    private synchronized void ensurePoolSizeInvariant() {
        Preconditions.checkState((!this.isMaxSizeSoftCapExceeded() || this.mFree.mNumBytes == 0 ? 1 : 0) != 0);
    }

    private synchronized void legacyInitBuckets(SparseIntArray inUseCounts) {
        Preconditions.checkNotNull((Object)inUseCounts);
        this.mBuckets.clear();
        SparseIntArray bucketSizes = this.mPoolParams.bucketSizes;
        if (bucketSizes != null) {
            for (int i = 0; i < bucketSizes.size(); ++i) {
                int bucketSize = bucketSizes.keyAt(i);
                int maxLength = bucketSizes.valueAt(i);
                int bucketInUseCount = inUseCounts.get(bucketSize, 0);
                this.mBuckets.put(bucketSize, new Bucket(this.getSizeInBytes(bucketSize), maxLength, bucketInUseCount, this.mPoolParams.fixBucketsReinitialization));
            }
            this.mAllowNewBuckets = false;
        } else {
            this.mAllowNewBuckets = true;
        }
    }

    private synchronized void initBuckets() {
        SparseIntArray bucketSizes = this.mPoolParams.bucketSizes;
        if (bucketSizes != null) {
            this.fillBuckets(bucketSizes);
            this.mAllowNewBuckets = false;
        } else {
            this.mAllowNewBuckets = true;
        }
    }

    private void fillBuckets(SparseIntArray bucketSizes) {
        this.mBuckets.clear();
        for (int i = 0; i < bucketSizes.size(); ++i) {
            int bucketSize = bucketSizes.keyAt(i);
            int maxLength = bucketSizes.valueAt(i);
            this.mBuckets.put(bucketSize, new Bucket(this.getSizeInBytes(bucketSize), maxLength, 0, this.mPoolParams.fixBucketsReinitialization));
        }
    }

    private List<Bucket<V>> refillBuckets() {
        ArrayList<Bucket<V>> bucketsToTrim = new ArrayList<Bucket<V>>(this.mBuckets.size());
        int len = this.mBuckets.size();
        for (int i = 0; i < len; ++i) {
            Bucket oldBucket = (Bucket)this.mBuckets.valueAt(i);
            int bucketSize = oldBucket.mItemSize;
            int maxLength = oldBucket.mMaxLength;
            int bucketInUseCount = oldBucket.getInUseCount();
            if (oldBucket.getFreeListSize() > 0) {
                bucketsToTrim.add(oldBucket);
            }
            this.mBuckets.setValueAt(i, new Bucket(this.getSizeInBytes(bucketSize), maxLength, bucketInUseCount, this.mPoolParams.fixBucketsReinitialization));
        }
        return bucketsToTrim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void trimToNothing() {
        List<Bucket<V>> bucketsToTrim;
        BasePool basePool = this;
        synchronized (basePool) {
            if (this.mPoolParams.fixBucketsReinitialization) {
                bucketsToTrim = this.refillBuckets();
            } else {
                bucketsToTrim = new ArrayList<Bucket<V>>(this.mBuckets.size());
                SparseIntArray inUseCounts = new SparseIntArray();
                for (int i = 0; i < this.mBuckets.size(); ++i) {
                    Bucket bucket = (Bucket)this.mBuckets.valueAt(i);
                    if (bucket.getFreeListSize() > 0) {
                        bucketsToTrim.add(bucket);
                    }
                    inUseCounts.put(this.mBuckets.keyAt(i), bucket.getInUseCount());
                }
                this.legacyInitBuckets(inUseCounts);
            }
            this.mFree.reset();
            this.logStats();
        }
        this.onParamsChanged();
        for (int i = 0; i < bucketsToTrim.size(); ++i) {
            V item;
            Bucket<V> bucket = bucketsToTrim.get(i);
            while ((item = bucket.pop()) != null) {
                this.free(item);
            }
        }
    }

    @VisibleForTesting
    synchronized void trimToSoftCap() {
        if (this.isMaxSizeSoftCapExceeded()) {
            this.trimToSize(this.mPoolParams.maxSizeSoftCap);
        }
    }

    @VisibleForTesting
    synchronized void trimToSize(int targetSize) {
        int bytesToFree = Math.min(this.mUsed.mNumBytes + this.mFree.mNumBytes - targetSize, this.mFree.mNumBytes);
        if (bytesToFree <= 0) {
            return;
        }
        if (FLog.isLoggable((int)2)) {
            FLog.v(this.TAG, (String)"trimToSize: TargetSize = %d; Initial Size = %d; Bytes to free = %d", (Object)targetSize, (Object)(this.mUsed.mNumBytes + this.mFree.mNumBytes), (Object)bytesToFree);
        }
        this.logStats();
        for (int i = 0; i < this.mBuckets.size() && bytesToFree > 0; ++i) {
            Object value;
            Bucket bucket = (Bucket)this.mBuckets.valueAt(i);
            while (bytesToFree > 0 && (value = bucket.pop()) != null) {
                this.free(value);
                bytesToFree -= bucket.mItemSize;
                this.mFree.decrement(bucket.mItemSize);
            }
        }
        this.logStats();
        if (FLog.isLoggable((int)2)) {
            FLog.v(this.TAG, (String)"trimToSize: TargetSize = %d; Final Size = %d", (Object)targetSize, (Object)(this.mUsed.mNumBytes + this.mFree.mNumBytes));
        }
    }

    private synchronized Bucket<V> getBucketIfPresent(int bucketedSize) {
        return (Bucket)this.mBuckets.get(bucketedSize);
    }

    @VisibleForTesting
    synchronized Bucket<V> getBucket(int bucketedSize) {
        Bucket bucket = (Bucket)this.mBuckets.get(bucketedSize);
        if (bucket != null || !this.mAllowNewBuckets) {
            return bucket;
        }
        if (FLog.isLoggable((int)2)) {
            FLog.v(this.TAG, (String)"creating new bucket %s", (Object)bucketedSize);
        }
        Bucket<V> newBucket = this.newBucket(bucketedSize);
        this.mBuckets.put(bucketedSize, newBucket);
        return newBucket;
    }

    Bucket<V> newBucket(int bucketedSize) {
        return new Bucket(this.getSizeInBytes(bucketedSize), Integer.MAX_VALUE, 0, this.mPoolParams.fixBucketsReinitialization);
    }

    @VisibleForTesting
    synchronized boolean isMaxSizeSoftCapExceeded() {
        boolean isMaxSizeSoftCapExceeded;
        boolean bl = isMaxSizeSoftCapExceeded = this.mUsed.mNumBytes + this.mFree.mNumBytes > this.mPoolParams.maxSizeSoftCap;
        if (isMaxSizeSoftCapExceeded) {
            this.mPoolStatsTracker.onSoftCapReached();
        }
        return isMaxSizeSoftCapExceeded;
    }

    @VisibleForTesting
    synchronized boolean canAllocate(int sizeInBytes) {
        int hardCap = this.mPoolParams.maxSizeHardCap;
        if (sizeInBytes > hardCap - this.mUsed.mNumBytes) {
            this.mPoolStatsTracker.onHardCapReached();
            return false;
        }
        int softCap = this.mPoolParams.maxSizeSoftCap;
        if (sizeInBytes > softCap - (this.mUsed.mNumBytes + this.mFree.mNumBytes)) {
            this.trimToSize(softCap - sizeInBytes);
        }
        if (sizeInBytes > hardCap - (this.mUsed.mNumBytes + this.mFree.mNumBytes)) {
            this.mPoolStatsTracker.onHardCapReached();
            return false;
        }
        return true;
    }

    @SuppressLint(value={"InvalidAccessToGuardedField"})
    private void logStats() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(this.TAG, (String)"Used = (%d, %d); Free = (%d, %d)", (Object)this.mUsed.mCount, (Object)this.mUsed.mNumBytes, (Object)this.mFree.mCount, (Object)this.mFree.mNumBytes);
        }
    }

    public synchronized Map<String, Integer> getStats() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (int i = 0; i < this.mBuckets.size(); ++i) {
            int bucketedSize = this.mBuckets.keyAt(i);
            Bucket bucket = (Bucket)this.mBuckets.valueAt(i);
            String BUCKET_USED_KEY = "buckets_used_" + this.getSizeInBytes(bucketedSize);
            stats.put(BUCKET_USED_KEY, bucket.getInUseCount());
        }
        stats.put("soft_cap", this.mPoolParams.maxSizeSoftCap);
        stats.put("hard_cap", this.mPoolParams.maxSizeHardCap);
        stats.put("used_count", this.mUsed.mCount);
        stats.put("used_bytes", this.mUsed.mNumBytes);
        stats.put("free_count", this.mFree.mCount);
        stats.put("free_bytes", this.mFree.mNumBytes);
        return stats;
    }

    public static class PoolSizeViolationException
    extends RuntimeException {
        public PoolSizeViolationException(int hardCap, int usedBytes, int freeBytes, int allocSize) {
            super("Pool hard cap violation? Hard cap = " + hardCap + " Used size = " + usedBytes + " Free size = " + freeBytes + " Request size = " + allocSize);
        }
    }

    public static class SizeTooLargeException
    extends InvalidSizeException {
        public SizeTooLargeException(Object size) {
            super(size);
        }
    }

    public static class InvalidSizeException
    extends RuntimeException {
        public InvalidSizeException(Object size) {
            super("Invalid size: " + size.toString());
        }
    }

    public static class InvalidValueException
    extends RuntimeException {
        public InvalidValueException(Object value) {
            super("Invalid value: " + value.toString());
        }
    }

    @NotThreadSafe
    @VisibleForTesting
    static class Counter {
        private static final String TAG = "com.facebook.imagepipeline.memory.BasePool.Counter";
        int mCount;
        int mNumBytes;

        Counter() {
        }

        public void increment(int numBytes) {
            ++this.mCount;
            this.mNumBytes += numBytes;
        }

        public void decrement(int numBytes) {
            if (this.mNumBytes >= numBytes && this.mCount > 0) {
                --this.mCount;
                this.mNumBytes -= numBytes;
            } else {
                FLog.wtf((String)TAG, (String)"Unexpected decrement of %d. Current numBytes = %d, count = %d", (Object[])new Object[]{numBytes, this.mNumBytes, this.mCount});
            }
        }

        public void reset() {
            this.mCount = 0;
            this.mNumBytes = 0;
        }
    }
}

