/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import com.facebook.common.internal.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MediaVariations {
    private final String mMediaId;
    @Nullable
    private final List<Variant> mVariants;
    private final boolean mForceRequestForSpecifiedUri;

    private MediaVariations(Builder builder) {
        this.mMediaId = builder.mMediaId;
        this.mVariants = builder.mVariants;
        this.mForceRequestForSpecifiedUri = builder.mForceRequestForSpecifiedUri;
    }

    public String getMediaId() {
        return this.mMediaId;
    }

    @Nullable
    public List<Variant> getVariants() {
        return this.mVariants;
    }

    public boolean shouldForceRequestForSpecifiedUri() {
        return this.mForceRequestForSpecifiedUri;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MediaVariations)) {
            return false;
        }
        MediaVariations otherVariations = (MediaVariations)o;
        return Objects.equal((Object)this.mMediaId, (Object)otherVariations.mMediaId) && this.mForceRequestForSpecifiedUri == otherVariations.mForceRequestForSpecifiedUri && Objects.equal(this.mVariants, otherVariations.mVariants);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mMediaId, this.mForceRequestForSpecifiedUri, this.mVariants});
    }

    public String toString() {
        return String.format((Locale)null, "%s-%b-%s", this.mMediaId, this.mForceRequestForSpecifiedUri, this.mVariants);
    }

    @Nullable
    public static MediaVariations forMediaId(@Nullable String mediaId) {
        if (mediaId == null || mediaId.isEmpty()) {
            return null;
        }
        return MediaVariations.newBuilderForMediaId(mediaId).build();
    }

    public static Builder newBuilderForMediaId(String mediaId) {
        return new Builder(mediaId);
    }

    public static class Builder {
        private final String mMediaId;
        private List<Variant> mVariants;
        private boolean mForceRequestForSpecifiedUri = false;

        private Builder(String mediaId) {
            this.mMediaId = mediaId;
        }

        public Builder addVariant(Uri uri, int width, int height) {
            if (this.mVariants == null) {
                this.mVariants = new ArrayList<Variant>();
            }
            this.mVariants.add(new Variant(uri, width, height));
            return this;
        }

        public Builder setForceRequestForSpecifiedUri(boolean forceRequestForSpecifiedUri) {
            this.mForceRequestForSpecifiedUri = forceRequestForSpecifiedUri;
            return this;
        }

        public MediaVariations build() {
            return new MediaVariations(this);
        }
    }

    public static final class Variant {
        private final Uri mUri;
        private final int mWidth;
        private final int mHeight;

        public Variant(Uri uri, int width, int height) {
            this.mUri = uri;
            this.mWidth = width;
            this.mHeight = height;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant otherVariant = (Variant)o;
            return Objects.equal((Object)this.mUri, (Object)otherVariant.mUri) && this.mWidth == otherVariant.mWidth && this.mHeight == otherVariant.mHeight;
        }

        public int hashCode() {
            int hashCode = this.mUri.hashCode();
            hashCode = 31 * hashCode + this.mWidth;
            hashCode = 31 * hashCode + this.mHeight;
            return hashCode;
        }

        public String toString() {
            return String.format((Locale)null, "%dx%d %s", this.mWidth, this.mHeight, this.mUri);
        }
    }
}

